<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-15 17:37:41
 */
namespace Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateOrder;

class OrderCommand {
    /**
     * @var  int
     * 用户id
     * validation: 
     */
    public int $userId;
    /**
     * @var  mixed
     * 用户手机号
     * validation: 
     */
    public  $userPhone = null;
    /**
     * @var  string
     * 用户名
     * validation: 
     */
    public string $userName;
    /**
     * @var  int
     * 门店id
     * validation: 
     */
    public int $storeId;
    /**
     * @var  float
     * 订单总金额(单位分)
     * validation: gte:0
     */
    public float $money;
    /**
     * @var  null|float
     * 实际支付金额(单位分)
     * validation: nullable|gte:0
     */
    public ?float $realMoney = null;
    /**
     * @var  null|float
     * 礼品卡支付金额(单位分)
     * validation: nullable|gte:0
     */
    public ?float $giftCardPayMoney = null;
    /**
     * @var  null|float
     * 商场卡支付金额(单位分)
     * validation: nullable|gte:0
     */
    public ?float $marketCardMoney = null;
    /**
     * @var  string
     * 渠道,默认抖音
     * validation: type:channelType
     */
    public string $channel;
    /**
     * @var  string
     * 提交时间
     * validation: 
     */
    public string $submittedAt;
    /**
     * @var  null|string
     * 预约时间
     * validation: 
     */
    public ?string $reserveTime = null;
    /**
     * @var  array
     * 扩展信息
     * validation: 
     */
    public array $extend = [];
    /**
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateSubOrder\SubOrderCommand[]
     * 子订单信息
     * validation: 
     */
    public array $subOrder;

    public function __construct (int $userId = 0, string $userName = '', int $storeId = 0, float $money = 0.0, string $channel = '', string $submittedAt = '', array $subOrder = []) {
        $this->userId = $userId;
        $this->userName = $userName;
        $this->storeId = $storeId;
        $this->money = $money;
        $this->channel = $channel;
        $this->submittedAt = $submittedAt;
        $this->subOrder = $subOrder;
    }

    public static function create(int $userId = 0, string $userName = '', int $storeId = 0, float $money = 0.0, string $channel = '', string $submittedAt = '', array $subOrder = []): self {
        return new self($userId, $userName, $storeId, $money, $channel, $submittedAt, $subOrder);
    }

    public function setUserId(int $userId): self {
        $this->userId = $userId;

        return $this;
    }

    public function setUserPhone( $userPhone): self {
        $this->userPhone = $userPhone;

        return $this;
    }

    public function setUserName(string $userName): self {
        $this->userName = $userName;

        return $this;
    }

    public function setStoreId(int $storeId): self {
        $this->storeId = $storeId;

        return $this;
    }

    public function setMoney(float $money): self {
        $this->money = $money;

        return $this;
    }

    public function setRealMoney(?float $realMoney): self {
        $this->realMoney = $realMoney;

        return $this;
    }

    public function setGiftCardPayMoney(?float $giftCardPayMoney): self {
        $this->giftCardPayMoney = $giftCardPayMoney;

        return $this;
    }

    public function setMarketCardMoney(?float $marketCardMoney): self {
        $this->marketCardMoney = $marketCardMoney;

        return $this;
    }

    public function setChannel(string $channel): self {
        $this->channel = $channel;

        return $this;
    }

    public function setSubmittedAt(string $submittedAt): self {
        $this->submittedAt = $submittedAt;

        return $this;
    }

    public function setReserveTime(?string $reserveTime): self {
        $this->reserveTime = $reserveTime;

        return $this;
    }

    public function setExtend(array $extend): self {
        $this->extend = $extend;

        return $this;
    }

    public function setSubOrder(array $subOrder): self {
        $this->subOrder = $subOrder;

        return $this;
    }
}