<?php
namespace Mainto\Bridge\Invokes\HimoAggregateOrder\AggregateOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAggregateOrderNoByParams(array $params)
 * @method getAggregateSubOrderNosByParams(array $params)
 * @method detailByParams(array $params)
 * @method getAggregateOrderInfoByParams(array $params)
 */
class AggregateOrderSearch {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据订单编号和类型查询聚合订单编号
     *
     * @param  string $outOrderNo 外部订单编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrderSearch\AggregateOrderNoDTO
     */
    public static function getAggregateOrderNo (string $outOrderNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAggregateOrderNo([
                            "outOrderNo" => $outOrderNo,
                        ]),
            "\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrderSearch\AggregateOrderNoDTO"
        );
    }

    /**
     * 根据聚合订单获取订单列表
     *
     * @param  string $aggregateOrderNo 聚合订单编号 [ require true ]
     * @param  bool $withDeleted 是否包含删除订单 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrderSearch\AggregateWithSubOrderNosDTO
     */
    public static function getAggregateSubOrderNos (string $aggregateOrderNo, bool $withDeleted = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAggregateSubOrderNos([
                            "aggregateOrderNo" => $aggregateOrderNo,
                            "withDeleted" => $withDeleted,
                        ]),
            "\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrderSearch\AggregateWithSubOrderNosDTO"
        );
    }

    /**
     * 获取聚合订单详情
     *
     * @param  string $aggregateOrderNo 聚合订单编号 [ require true ]
     * @param  bool $withDeleted 是否包含删除订单 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrder\AggregateOrderDTO
     */
    public static function detail (string $aggregateOrderNo, bool $withDeleted = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "aggregateOrderNo" => $aggregateOrderNo,
                            "withDeleted" => $withDeleted,
                        ]),
            "\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrder\AggregateOrderDTO"
        );
    }

    /**
     * 通过外部订单号获取聚合订单详情
     *
     * @param  string $outOrderNo 聚合订单编号 [ require true ]
     * @param  bool $withSubOrder 需要子订单 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrder\AggregateOrderDTO
     */
    public static function getAggregateOrderInfo (string $outOrderNo, bool $withSubOrder = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAggregateOrderInfo([
                            "outOrderNo" => $outOrderNo,
                            "withSubOrder" => $withSubOrder,
                        ]),
            "\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrder\AggregateOrderDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoAggregateOrder', 'AggregateOrder\AggregateOrderSearch');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoAggregateOrder', 'AggregateOrder\AggregateOrderSearch');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}