<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-18 10:33:56
 */
namespace Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateSubOrderItem;

class SubOrderItemCommand {
    /**
     * @var  int
     * 产品id
     * validation: 
     */
    public int $productId;
    /**
     * @var  string
     * 产品类型
     * validation: type:itemType
     */
    public string $itemType;
    /**
     * @var  mixed
     * 唯一标识，在未购买时，可能没有聚合订单关联产品id,如果有关联产品id，则传递产品id
     * validation: 
     */
    public  $unique = null;
    /**
     * @var  string
     * 产品名称
     * validation: 
     */
    public string $productName;
    /**
     * @var  string
     * 产品图片
     * validation: 
     */
    public string $productImage;
    /**
     * @var  int
     * 购买产品数量
     * validation: 
     */
    public int $num;
    /**
     * @var  array
     * sku快照信息
     * validation: 
     */
    public array $skuInfo = [];
    /**
     * @var  float
     * 产品金额（产品最终单价,单位分)
     * validation: 
     */
    public float $productMoney;
    /**
     * @var  null|float
     * 实际支付金额(单位分)
     * validation: 
     */
    public ?float $realMoney = null;
    /**
     * @var  null|float
     * 增值属性原价(单位分)
     * validation: 
     */
    public ?float $attributeMoney = null;
    /**
     * @var  null|float
     * 增值属性支付金额(单位分)
     * validation: 
     */
    public ?float $attributeRealMoney = null;
    /**
     * @var  array
     * 增值属性详情
     * validation: 
     */
    public array $attributeInfo = [];
    /**
     * @var  array
     * 支付信息
     * validation: 
     */
    public array $priceCalcInfo = [];
    /**
     * @var  array
     * 扩展字段，用于前端和非重要业务
     * validation: 
     */
    public array $extend = [];

    public function __construct (int $productId = 0, string $itemType = '', string $productName = '', string $productImage = '', int $num = 0, float $productMoney = 0.0) {
        $this->productId = $productId;
        $this->itemType = $itemType;
        $this->productName = $productName;
        $this->productImage = $productImage;
        $this->num = $num;
        $this->productMoney = $productMoney;
    }

    public static function create(int $productId = 0, string $itemType = '', string $productName = '', string $productImage = '', int $num = 0, float $productMoney = 0.0): self {
        return new self($productId, $itemType, $productName, $productImage, $num, $productMoney);
    }

    public function setProductId(int $productId): self {
        $this->productId = $productId;

        return $this;
    }

    public function setItemType(string $itemType): self {
        $this->itemType = $itemType;

        return $this;
    }

    public function setUnique( $unique): self {
        $this->unique = $unique;

        return $this;
    }

    public function setProductName(string $productName): self {
        $this->productName = $productName;

        return $this;
    }

    public function setProductImage(string $productImage): self {
        $this->productImage = $productImage;

        return $this;
    }

    public function setNum(int $num): self {
        $this->num = $num;

        return $this;
    }

    public function setSkuInfo(array $skuInfo): self {
        $this->skuInfo = $skuInfo;

        return $this;
    }

    public function setProductMoney(float $productMoney): self {
        $this->productMoney = $productMoney;

        return $this;
    }

    public function setRealMoney(?float $realMoney): self {
        $this->realMoney = $realMoney;

        return $this;
    }

    public function setAttributeMoney(?float $attributeMoney): self {
        $this->attributeMoney = $attributeMoney;

        return $this;
    }

    public function setAttributeRealMoney(?float $attributeRealMoney): self {
        $this->attributeRealMoney = $attributeRealMoney;

        return $this;
    }

    public function setAttributeInfo(array $attributeInfo): self {
        $this->attributeInfo = $attributeInfo;

        return $this;
    }

    public function setPriceCalcInfo(array $priceCalcInfo): self {
        $this->priceCalcInfo = $priceCalcInfo;

        return $this;
    }

    public function setExtend(array $extend): self {
        $this->extend = $extend;

        return $this;
    }
}