<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-12 11:00:48
 */
namespace Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateSubOrder;

class SubOrderCommand {
    /**
     * @var  string
     * 外部订单编号
     * validation: 
     */
    public string $outOrderNo;
    /**
     * @var  int
     * 外部订单id
     * validation: 
     */
    public int $outOrderId;
    /**
     * @var  string
     * 订单类型
     * validation: type:orderType
     */
    public string $type;
    /**
     * @var  string
     * 订单状态
     * validation: 
     */
    public string $status;
    /**
     * @var  null|string
     * 预约时间
     * validation: 
     */
    public ?string $reserveTime = null;
    /**
     * @var  float
     * 订单总金额(单位分)
     * validation: gte:0
     */
    public float $money;
    /**
     * @var  float
     * 实际支付金额(单位分)
     * validation: nullable|gte:0
     */
    public float $realMoney;
    /**
     * @var  null|float
     * 礼品卡支付金额(单位分)
     * validation: nullable|gte:0
     */
    public ?float $giftCardPayMoney = null;
    /**
     * @var  null|float
     * 商场卡支付金额(单位分)
     * validation: nullable|gte:0
     */
    public ?float $marketCardMoney = null;
    /**
     * @var  string
     * 提交时间
     * validation: 
     */
    public string $submittedAt;
    /**
     * @var  array
     * 扩展信息
     * validation: 
     */
    public array $extend = [];
    /**
     * @var  array
     * 支付信息
     * validation: 
     */
    public array $paymentInfo;
    /**
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateSubOrderItem\SubOrderItemCommand[]
     * 子订单产品信息
     * validation: 
     */
    public array $items;

    public function __construct (string $outOrderNo = '', int $outOrderId = 0, string $type = '', string $status = '', float $money = 0.0, float $realMoney = 0.0, string $submittedAt = '', array $paymentInfo = [], array $items = []) {
        $this->outOrderNo = $outOrderNo;
        $this->outOrderId = $outOrderId;
        $this->type = $type;
        $this->status = $status;
        $this->money = $money;
        $this->realMoney = $realMoney;
        $this->submittedAt = $submittedAt;
        $this->paymentInfo = $paymentInfo;
        $this->items = $items;
    }

    public static function create(string $outOrderNo = '', int $outOrderId = 0, string $type = '', string $status = '', float $money = 0.0, float $realMoney = 0.0, string $submittedAt = '', array $paymentInfo = [], array $items = []): self {
        return new self($outOrderNo, $outOrderId, $type, $status, $money, $realMoney, $submittedAt, $paymentInfo, $items);
    }

    public function setOutOrderNo(string $outOrderNo): self {
        $this->outOrderNo = $outOrderNo;

        return $this;
    }

    public function setOutOrderId(int $outOrderId): self {
        $this->outOrderId = $outOrderId;

        return $this;
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }

    public function setStatus(string $status): self {
        $this->status = $status;

        return $this;
    }

    public function setReserveTime(?string $reserveTime): self {
        $this->reserveTime = $reserveTime;

        return $this;
    }

    public function setMoney(float $money): self {
        $this->money = $money;

        return $this;
    }

    public function setRealMoney(float $realMoney): self {
        $this->realMoney = $realMoney;

        return $this;
    }

    public function setGiftCardPayMoney(?float $giftCardPayMoney): self {
        $this->giftCardPayMoney = $giftCardPayMoney;

        return $this;
    }

    public function setMarketCardMoney(?float $marketCardMoney): self {
        $this->marketCardMoney = $marketCardMoney;

        return $this;
    }

    public function setSubmittedAt(string $submittedAt): self {
        $this->submittedAt = $submittedAt;

        return $this;
    }

    public function setExtend(array $extend): self {
        $this->extend = $extend;

        return $this;
    }

    public function setPaymentInfo(array $paymentInfo): self {
        $this->paymentInfo = $paymentInfo;

        return $this;
    }

    public function setItems(array $items): self {
        $this->items = $items;

        return $this;
    }
}