<?php
namespace Mainto\Bridge\Invokes\HimoAggregateOrder\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncSettleByParams(array $params)
 * @method refundReviewCallbackByParams(array $params)
 */
class AggregateOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 分账结果通知
     *
     * @param  string $data 交易返回数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncSettle (string $data) {
        return self::getClass()->syncSettle([
            "data" => $data,
        ]);
    }

    /**
     * 聚合订单-退款申请事件
     *
     * @param  int $outRefundId 聚合单退款ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function refundReviewCallback (int $outRefundId) {
        return self::getClass()->refundReviewCallback([
            "outRefundId" => $outRefundId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoAggregateOrder', 'MessageHook\AggregateOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoAggregateOrder', 'MessageHook\AggregateOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}