<?php
namespace Mainto\Bridge\Invokes\HimoAggregateOrder\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\OrderStatusChangeCommand $params)
 * @method expressByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\OrderUpdate\OrderCommand $params)
 * @method createRefundByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\CreateRefundCommand $params)
 * @method refundPassByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\RefundPassCommand $params)
 */
class RetailOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 应用于取消 和 完成
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\OrderStatusChangeCommand $statusChange
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\OrderStatusChangeCommand $statusChange) {
        return self::getClass()->update($statusChange);
    }


    /**
     * 提货
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\OrderUpdate\OrderCommand $orderCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function express (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\OrderUpdate\OrderCommand $orderCommand) {
        return self::getClass()->express($orderCommand);
    }


    /**
     * 创建退款
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\CreateRefundCommand $createRefund
     * @throws  \Exception
     * @return  int
     */
    public static function createRefund (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\CreateRefundCommand $createRefund) {
        return self::getClass()->createRefund($createRefund);
    }


    /**
     * 退款通过
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\RefundPassCommand $refundPass
     * @throws  \Exception
     * @return  bool
     */
    public static function refundPass (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\RetailOrder\RefundPassCommand $refundPass) {
        return self::getClass()->refundPass($refundPass);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoAggregateOrder', 'MessageHook\RetailOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoAggregateOrder', 'MessageHook\RetailOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}