<?php
namespace Mainto\Bridge\Invokes\HimoAggregateOrder\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\OrderUpdateStatusCommand $params)
 * @method photoFinishedByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\PhotoFinishedCommand $params)
 * @method createRefundByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\CreateRefundCommand $params)
 * @method refundPassByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\RefundPassCommand $params)
 * @method changeStoreByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ChangeStoreCommand $params)
 * @method reshootByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ReshootCommand $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 状态更新
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\OrderUpdateStatusCommand $orderUpdateStatus
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\OrderUpdateStatusCommand $orderUpdateStatus) {
        return self::getClass()->update($orderUpdateStatus);
    }


    /**
     * 照片完成时间
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\PhotoFinishedCommand $photoFinishedCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function photoFinished (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\PhotoFinishedCommand $photoFinishedCmd) {
        return self::getClass()->photoFinished($photoFinishedCmd);
    }


    /**
     * 创建退款
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\CreateRefundCommand $createRefund
     * @throws  \Exception
     * @return  bool
     */
    public static function createRefund (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\CreateRefundCommand $createRefund) {
        return self::getClass()->createRefund($createRefund);
    }


    /**
     * 退款通过
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\RefundPassCommand $refundPass
     * @throws  \Exception
     * @return  bool
     */
    public static function refundPass (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\RefundPassCommand $refundPass) {
        return self::getClass()->refundPass($refundPass);
    }


    /**
     * 订单转门店
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ChangeStoreCommand $changeStore
     * @throws  \Exception
     * @return  void
     */
    public static function changeStore (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ChangeStoreCommand $changeStore) {
        return self::getClass()->changeStore($changeStore);
    }


    /**
     * 订单重拍
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ReshootCommand $reshootCmd
     * @throws  \Exception
     * @return  void
     */
    public static function reshoot (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ReshootCommand $reshootCmd) {
        return self::getClass()->reshoot($reshootCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoAggregateOrder', 'MessageHook\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoAggregateOrder', 'MessageHook\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}