<?php
namespace Mainto\Bridge\Invokes\HimoAggregateOrder\AggregateOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateOrder\OrderCommand $params)
 * @method cancelByParams(array $params)
 * @method prePaidByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateOrder\OrderPrePaidCommand $params)
 * @method paidByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateOrder\OrderPaidCommand $params)
 */
class AggregateOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建聚合订单
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateOrder\OrderCommand $aggregateOrderCommand
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrder\CreateAggregateOrderDTO
     */
    public static function create (\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateOrder\OrderCommand $aggregateOrderCommand) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($aggregateOrderCommand),
            "\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrder\CreateAggregateOrderDTO"
        );
    }


    /**
     * 取消订单
     *
     * @param  string $aggregateOrderNo 聚合订单编号 [ require true ]
     * @param  string $cancelReason 取消原因 [ require false ]
     * @param  bool $withDeleted 是否包含删除订单 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancel (string $aggregateOrderNo, string $cancelReason = null, bool $withDeleted = false) {
        return self::getClass()->cancel([
            "aggregateOrderNo" => $aggregateOrderNo,
            "cancelReason" => $cancelReason,
            "withDeleted" => $withDeleted,
        ]);
    }

    /**
     * 在设置支付之前调用，设置子订单相关联的商场卡和礼品卡的预支付
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateOrder\OrderPrePaidCommand $orderPrePaidCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function prePaid (\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateOrder\OrderPrePaidCommand $orderPrePaidCommand) {
        return self::getClass()->prePaid($orderPrePaidCommand);
    }


    /**
     * 设置支付
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateOrder\OrderPaidCommand $aggregateOrderPaidCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function paid (\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\Command\AggregateOrder\OrderPaidCommand $aggregateOrderPaidCommand) {
        return self::getClass()->paid($aggregateOrderPaidCommand);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoAggregateOrder', 'AggregateOrder\AggregateOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoAggregateOrder', 'AggregateOrder\AggregateOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}