<?php
namespace Mainto\Bridge\Enums\HimoAggregateOrder\AggregateOrder\SubOrder;

class StatusEnum {
    /**
     * 全部取消
     */
    const SUBMITTED = ['order' => 'submitted','retail_order' => 'submitted'];
    /**
     * 全部取消
     */
    const CANCELED = ['order' => 'canceled','retail_order' => 'canceled'];
    /**
     * 全部支付
     */
    const PAID = ['order' => 'wait_shooting','retail_order' => 'paid'];
    /**
     * 全部开始
     */
    const USED = ['order' => 'working','retail_order' => ''];
    /**
     * 全部支付
     */
    const WORKING = ['order' => 'working','retail_order' => 'finished'];
    /**
     * 全部退款
     */
    const REFUND = ['order' => 'closed_by_refund','retail_order' => 'after_sale_closed'];
    /**
     * 全部取消
     */
    const CANCELED_AND_AFTER = ['order' => [0 => 'canceled',1 => 'closed'],'retail_order' => [0 => 'canceled',1 => 'closed']];
    /**
     * 开始及之后的状态
     */
    const USED_AND_AFTER = ['order' => [0 => 'working',1 => 'finished',2 => 'closed_by_refund'],'retail_order' => [0 => 'paid',1 => 'after_sale_closed']];
    /**
     * 退款之前的状态
     */
    const REFUND_AND_BEFORE = ['order' => [0 => 'wait_shooting',1 => 'working',2 => 'finished'],'retail_order' => [0 => 'paid']];
}