<?php
namespace Mainto\Bridge\Invokes\HimoAggregateOrder\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cancelByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\OrderCancelCommand $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\OrderUpdateStatusCommand $params)
 * @method lookPhotoByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\LookPhotoCommand $params)
 * @method createRefundByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\CreateRefundCommand $params)
 * @method refundPassByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\RefundPassCommand $params)
 * @method changeStoreByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ChangeStoreCommand $params)
 * @method reshootByParams(array|\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ReshootCommand $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 取消订单
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\OrderCancelCommand $orderCancel
     * @throws  \Exception
     * @return  bool
     */
    public static function cancel (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\OrderCancelCommand $orderCancel) {
        return self::getClass()->cancel($orderCancel);
    }


    /**
     * 状态更新
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\OrderUpdateStatusCommand $orderUpdateStatus
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\OrderUpdateStatusCommand $orderUpdateStatus) {
        return self::getClass()->update($orderUpdateStatus);
    }


    /**
     * 看片完成
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\LookPhotoCommand $lookPhotoCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function lookPhoto (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\LookPhotoCommand $lookPhotoCommand) {
        return self::getClass()->lookPhoto($lookPhotoCommand);
    }


    /**
     * 创建退款
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\CreateRefundCommand $createRefund
     * @throws  \Exception
     * @return  bool
     */
    public static function createRefund (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\CreateRefundCommand $createRefund) {
        return self::getClass()->createRefund($createRefund);
    }


    /**
     * 退款通过
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\RefundPassCommand $refundPass
     * @throws  \Exception
     * @return  bool
     */
    public static function refundPass (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\RefundPassCommand $refundPass) {
        return self::getClass()->refundPass($refundPass);
    }


    /**
     * 订单转门店
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ChangeStoreCommand $changeStore
     * @throws  \Exception
     * @return  bool
     */
    public static function changeStore (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ChangeStoreCommand $changeStore) {
        return self::getClass()->changeStore($changeStore);
    }


    /**
     * 订单重拍
     *
     * @var  \Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ReshootCommand $reshootCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function reshoot (\Mainto\Bridge\Structs\HimoAggregateOrder\MessageHook\Command\Order\ReshootCommand $reshootCmd) {
        return self::getClass()->reshoot($reshootCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoAggregateOrder', 'MessageHook\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoAggregateOrder', 'MessageHook\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}