<?php
namespace Mainto\Bridge\Invokes\HimoAggregateOrder\Crontab;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setOrderNoByParams(array $params)
 * @method setSettleByParams(array $params)
 */
class AggregateOrderCrontab {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 自动设置订单编号(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setOrderNo () {
        return self::getClass()->setOrderNo();
    }

    /**
     * 资金解冻
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setSettle () {
        return self::getClass()->setSettle();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoAggregateOrder', 'Crontab\AggregateOrderCrontab');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoAggregateOrder', 'Crontab\AggregateOrderCrontab');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}