<?php
namespace Mainto\Bridge\Invokes\HimoActivity\ArtFestivalActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method mockActivityItemsByParams(array $params)
 * @method tempClearVoteByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 为活动添加参赛数据 --- 测试用
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  uint $count 参赛记录数量 [ require true ]
     * @param  array $imgs 上传的照片 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function mockActivityItems (string $activity_id, int $count, array $imgs = [0 => '2021/06/29/ljWSQnI_cMgeLL05oPay1weh7Q-v.jpg']) {
        return self::getClass()->mockActivityItems([
            "activity_id" => $activity_id,
            "count" => $count,
            "imgs" => $imgs,
        ]);
    }

    /**
     * 清空投票  --- 测试用
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $name 用户类型 [ require true ]
     * @param  uint $object_id 对象id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function tempClearVote (string $activity_id, string $name, int $object_id) {
        return self::getClass()->tempClearVote([
            "activity_id" => $activity_id,
            "name" => $name,
            "object_id" => $object_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'ArtFestivalActivity\Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'ArtFestivalActivity\Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}