<?php
namespace Mainto\Bridge\Invokes\HimoActivity\ArtFestivalActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getVoteRecordByTeamByParams(array $params)
 */
class Judge {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取参赛内容 --- 投票
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  uint $team_id 活动内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getVoteRecordByTeam (string $activity_id, int $team_id) {
        return self::getClass()->getVoteRecordByTeam([
            "activity_id" => $activity_id,
            "team_id" => $team_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'ArtFestivalActivity\Judge');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'ArtFestivalActivity\Judge');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}