<?php
namespace Mainto\Bridge\Invokes\HimoActivity\ArtFestivalActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSelfVoteRecordByParams(array $params)
 * @method editVoteRecordByParams(array $params)
 */
class VoteRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修改一个活动项目
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSelfVoteRecord (string $activity_id) {
        return self::getClass()->getSelfVoteRecord([
            "activity_id" => $activity_id,
        ]);
    }

    /**
     * 修改一个活动项目
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @support  array $activity_content 活动内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editVoteRecord (string $activity_id) {
        return self::getClass()->editVoteRecord([
            "activity_id" => $activity_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'ArtFestivalActivity\VoteRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'ArtFestivalActivity\VoteRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}