<?php
namespace Mainto\Bridge\Invokes\HimoActivity\ArtFestivalActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method voteByParams(array $params)
 * @method getVoteRecordByTeamByParams(array $params)
 * @method getActivityInfoByParams(array $params)
 * @method getRemainCountByParams(array $params)
 * @method getVoteRecordJudgeListByParams(array $params)
 */
class Judge {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 海马体艺术节 --- 投票接口
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $item_id 活动项目id -- 参赛纪录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function vote (string $activity_id, string $item_id) {
        return self::getClass()->vote([
            "activity_id" => $activity_id,
            "item_id" => $item_id,
        ]);
    }

    /**
     * 获取参赛内容 --- 投票
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  uint $team_id 活动内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getVoteRecordByTeam (string $activity_id, int $team_id) {
        return self::getClass()->getVoteRecordByTeam([
            "activity_id" => $activity_id,
            "team_id" => $team_id,
        ]);
    }

    /**
     * 获取活动内容
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActivityInfo (string $activity_id) {
        return self::getClass()->getActivityInfo([
            "activity_id" => $activity_id,
        ]);
    }

    /**
     * 获取活动当天剩余投票数
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRemainCount (string $activity_id) {
        return self::getClass()->getRemainCount([
            "activity_id" => $activity_id,
        ]);
    }

    /**
     * 获取排名列表详情
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  uint $page 页数 [ require true ]
     * @param  uint $page_size 长度 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getVoteRecordJudgeList (string $activity_id, int $page = 1, int $page_size = 10) {
        return self::getClass()->getVoteRecordJudgeList([
            "activity_id" => $activity_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'ArtFestivalActivity\Judge');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'ArtFestivalActivity\Judge');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}