<?php
namespace Mainto\Bridge\Invokes\HimoActivity\ArtFestivalActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSmsByParams(array $params)
 * @method getUserInfoByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取验证码
     *
     * @param  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSms (string $phone) {
        return self::getClass()->getSms([
            "phone" => $phone,
        ]);
    }

    /**
     * 获取用户信息-身份信息
     *
     * @support  string $loginType 登录类型 [ require true ]
     * @support  string $phone 手机号 require false
     * @support  string $smsCode 手机验证码 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'ArtFestivalActivity\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'ArtFestivalActivity\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}