<?php
namespace Mainto\Bridge\Invokes\HimoActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method signUpByParams(array $params)
 * @method captchaByParams(array $params)
 */
class Lens {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 我要报名
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $name 姓名 [ require true ]
     * @param  string $mobile 电话 [ require true ]
     * @param  string $lesson 课程 [ require true ]
     * @param  string $city 城市 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function signUp (string $activity_id, string $name, string $mobile, string $lesson, string $city, string $captcha) {
        return self::getClass()->signUp([
            "activity_id" => $activity_id,
            "name" => $name,
            "mobile" => $mobile,
            "lesson" => $lesson,
            "city" => $city,
            "captcha" => $captcha,
        ]);
    }

    /**
     * 获取验证码
     *
     * @support  string $mobile 电话 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function captcha () {
        return self::getClass()->captcha();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'Lens');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'Lens');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}