<?php
namespace Mainto\Bridge\Invokes\HimoActivity\ArtFestivalActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method refreshRandomScoreByParams(array $params)
 * @method autoStateChangeByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 刷新随机排名  --- 每天0点
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshRandomScore () {
        return self::getClass()->refreshRandomScore();
    }

    /**
     * 自动改变状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoStateChange () {
        return self::getClass()->autoStateChange();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'ArtFestivalActivity\Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'ArtFestivalActivity\Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}