<?php
namespace Mainto\Bridge\Invokes\HimoActivity\NVDActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method joinActivityByParams(array $params)
 * @method activityDetailByParams(array $params)
 * @method voteByParams(array $params)
 * @method voteMoreByParams(array $params)
 * @method voteListByParams(array $params)
 * @method activityListByParams(array $params)
 * @method myAlbumByParams(array $params)
 * @method imgRecognitionByParams(array $params)
 * @method getDiscountProductsByParams(array $params)
 * @method getCouponByParams(array $params)
 * @method getRecordByParams(array $params)
 * @method updateByParams(array $params)
 * @method flashSaleByParams(array $params)
 * @method flashSaleCallbackByParams(array $params)
 * @method getCouponNumByParams(array $params)
 * @method flashSaleHookByParams(array $params)
 * @method createActivityByParams(array $params)
 * @method deitActivityByParams(array $params)
 * @method activityNoticeByParams(array $params)
 * @method getActivityResByParams(array $params)
 * @method initCodeByParams(array $params)
 * @method syncRankByParams(array $params)
 */
class NVDActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 520投票 - 参加活动
     *
     * @support  string $nickName 昵称 [ require true ]
     * @support  int $photoId 照片云端ID [ require true ]
     * @support  bool $isAuthorize 是否同意授权 [ require true ]
     * @support  string $loveConfession 爱情告白 [ require true ]
     * @support  string $joinPhotoUrl 照片绝对路径 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinActivity () {
        return self::getClass()->joinActivity();
    }

    /**
     * 520投票 - 详情
     *
     * @support  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function activityDetail () {
        return self::getClass()->activityDetail();
    }

    /**
     * 520投票 - 投票
     *
     * @support  int $friendUserId 好友ID [ require true ]
     * @support  string $activityId 活动ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function vote () {
        return self::getClass()->vote();
    }

    /**
     * 520投票 - 剩余投票次数
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function voteMore () {
        return self::getClass()->voteMore();
    }

    /**
     * 520投票 - 投票列表
     *
     * @support  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function voteList () {
        return self::getClass()->voteList();
    }

    /**
     * 520投票 - 活动榜单
     *
     * @support  int $page 页数 require false
     * @support  int $pageSize 分页数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function activityList () {
        return self::getClass()->activityList();
    }

    /**
     * 520投票 - 我的相册
     *
     * @support  int $page 页数 require false
     * @support  int $pageSize 分页数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function myAlbum () {
        return self::getClass()->myAlbum();
    }

    /**
     * 520投票 - 图像处理
     *
     * @support  string $imageUrl 图片全路径 [ require true ]
     * @support  int $photoId 照片Id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function imgRecognition () {
        return self::getClass()->imgRecognition();
    }

    /**
     * 520投票 - 获取活动首页折扣产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDiscountProducts () {
        return self::getClass()->getDiscountProducts();
    }

    /**
     * 520投票 - 领取优惠券
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCoupon () {
        return self::getClass()->getCoupon();
    }

    /**
     * 520投票 - 领取优惠券记录
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRecord () {
        return self::getClass()->getRecord();
    }

    /**
     * 520投票 - 更新海报信息
     *
     * @support  string $billUrl 海报url [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 520投票 - 限时抢券
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function flashSale () {
        return self::getClass()->flashSale();
    }

    /**
     * 520投票 - 限时抢券回调
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function flashSaleCallback () {
        return self::getClass()->flashSaleCallback();
    }

    /**
     * 520投票 - 获取产品券库存
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCouponNum () {
        return self::getClass()->getCouponNum();
    }

    /**
     * 520投票 - 获取产品券库存
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $code 产品券Code [ require true ]
     * @support  string $tagName 标签名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function flashSaleHook () {
        return self::getClass()->flashSaleHook();
    }

    /**
     * 520投票 - 参加活动[手动添加]
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $nickName 昵称 [ require true ]
     * @support  int $photoId 照片云端ID [ require true ]
     * @support  bool $isAuthorize 是否同意授权 [ require true ]
     * @support  string $loveConfession 爱情告白 [ require true ]
     * @support  string $joinPhotoUrl 照片绝对路径 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createActivity () {
        return self::getClass()->createActivity();
    }

    /**
     * 520投票 - 编辑活动记录[手动编辑]
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  int $photoId 照片云端ID [ require true ]
     * @support  string $joinPhotoUrl 照片绝对路径 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deitActivity () {
        return self::getClass()->deitActivity();
    }

    /**
     * 2021-02-19 10点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function activityNotice () {
        return self::getClass()->activityNotice();
    }

    /**
     * 520投票 - 获取活动结果
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActivityRes () {
        return self::getClass()->getActivityRes();
    }

    /**
     * 520投票 - 初始化库存
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initCode () {
        return self::getClass()->initCode();
    }

    /**
     * 520投票同步排名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncRank () {
        return self::getClass()->syncRank();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'NVDActivity\NVDActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'NVDActivity\NVDActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}