<?php
namespace Mainto\Bridge\Invokes\HimoActivity\NVDActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method joinActivityByParams(array $params)
 * @method activityDetailByParams(array $params)
 * @method voteByParams(array $params)
 * @method voteListByParams(array $params)
 * @method activityListByParams(array $params)
 * @method myAlbumByParams(array $params)
 * @method imgRecognitionByParams(array $params)
 * @method getHomeInfoByParams(array $params)
 * @method getCouponByParams(array $params)
 * @method flashSaleByParams(array $params)
 * @method flashSaleCallbackByParams(array $params)
 * @method getCouponNumByParams(array $params)
 * @method createActivityByParams(array $params)
 */
class NVDActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 520投票 - 参加活动
     *
     * @support  string $nickName 昵称 [ require true ]
     * @support  int $photoId 照片云端ID [ require true ]
     * @support  bool $isAuthorize 是否同意授权 [ require true ]
     * @support  string $LoveConfession 爱情告白 [ require true ]
     * @support  string $joinPhotoUrl 照片绝对路径 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinActivity () {
        return self::getClass()->joinActivity();
    }

    /**
     * 520投票 - 详情
     *
     * @support  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function activityDetail () {
        return self::getClass()->activityDetail();
    }

    /**
     * 520投票 - 投票
     *
     * @support  int $friendUserId 好友ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function vote () {
        return self::getClass()->vote();
    }

    /**
     * 520投票 - 投票列表
     *
     * @support  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function voteList () {
        return self::getClass()->voteList();
    }

    /**
     * 520投票 - 活动榜单
     *
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  array
     */
    public static function activityList () {
        return self::getClass()->activityList();
    }

    /**
     * 520投票 - 我的相册
     *
     * @throws  \Exception
     * @return  array
     */
    public static function myAlbum () {
        return self::getClass()->myAlbum();
    }

    /**
     * 520投票 - 图像处理
     *
     * @support  string $imageUrl 图片全路径 [ require true ]
     * @support  int $photoId 照片Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function imgRecognition () {
        return self::getClass()->imgRecognition();
    }

    /**
     * 520投票 - 获取活动首页数据
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getHomeInfo () {
        return self::getClass()->getHomeInfo();
    }

    /**
     * 520投票 - 领取优惠券
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCoupon () {
        return self::getClass()->getCoupon();
    }

    /**
     * 520投票 - 限时抢券
     *
     * @support  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function flashSale () {
        return self::getClass()->flashSale();
    }

    /**
     * 520投票 - 限时抢券回调
     *
     * @support  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function flashSaleCallback () {
        return self::getClass()->flashSaleCallback();
    }

    /**
     * 520投票 - 获取产品券库存
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponNum () {
        return self::getClass()->getCouponNum();
    }

    /**
     * 520投票 - 参加活动[手动添加]
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $nickName 昵称 [ require true ]
     * @support  int $photoId 照片云端ID [ require true ]
     * @support  string $LoveConfession 爱情告白 [ require true ]
     * @support  string $joinPhotoUrl 照片绝对路径 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createActivity () {
        return self::getClass()->createActivity();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'NVDActivity\NVDActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'NVDActivity\NVDActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}