<?php
namespace Mainto\Bridge\Invokes\HimoActivity\NewYearActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method joinActivityByParams(array $params)
 * @method activityDetailByParams(array $params)
 * @method voteByParams(array $params)
 * @method voteListByParams(array $params)
 * @method activityListByParams(array $params)
 * @method myAlbumByParams(array $params)
 * @method voteMoreByParams(array $params)
 * @method imgRecognitionByParams(array $params)
 * @method MockDataByParams(array $params)
 */
class Activity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 东方美人 - 参加活动
     *
     * @support  string $nickName 昵称 [ require true ]
     * @support  int $photoId 照片云端ID [ require true ]
     * @support  string $joinPhotoUrl 照片绝对路径 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinActivity () {
        return self::getClass()->joinActivity();
    }

    /**
     * 东方美人 - 详情
     *
     * @support  int $userId 好友ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function activityDetail () {
        return self::getClass()->activityDetail();
    }

    /**
     * 东方美人 - 投票
     *
     * @support  int $friendUserId 好友ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function vote () {
        return self::getClass()->vote();
    }

    /**
     * 东方美人 - 投票列表
     *
     * @support  int $userId 好友ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function voteList () {
        return self::getClass()->voteList();
    }

    /**
     * 东方美人 - 活动榜单
     *
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  array
     */
    public static function activityList () {
        return self::getClass()->activityList();
    }

    /**
     * 东方美人 - 我的相册
     *
     * @throws  \Exception
     * @return  array
     */
    public static function myAlbum () {
        return self::getClass()->myAlbum();
    }

    /**
     * 东方美人 - 剩余投票次数
     *
     * @throws  \Exception
     * @return  array
     */
    public static function voteMore () {
        return self::getClass()->voteMore();
    }

    /**
     * 东方美人 - 图像处理
     *
     * @support  string $imageUrl 图片全路径 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function imgRecognition () {
        return self::getClass()->imgRecognition();
    }

    /**
     * 东方美人 - mock数据
     *
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function MockData () {
        return self::getClass()->MockData();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'NewYearActivity\Activity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'NewYearActivity\Activity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}