<?php
namespace Mainto\Bridge\Invokes\HimoActivity\NewYearActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method voteListByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method syncRankByParams(array $params)
 */
class ActivityAdmin {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 东方美人评选活动记录列表
     *
     * @support  string $name 用户名或昵称 
     * @support  string $phone 手机号 
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 东方美人评选活动记录.所有
     *
     * @support  string $name 用户名或昵称 
     * @support  string $phone 手机号 
     * @support  bool $sortAscBySort 是否按报名顺序顺序 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 好友投票记录列表
     *
     * @support  int $userId 用户id [ require true ]
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  array
     */
    public static function voteList () {
        return self::getClass()->voteList();
    }

    /**
     * 东方美人修改票数
     *
     * @support  int $userId 用户id [ require true ]
     * @support  int $pollNum 票数 [ require true ]
     * @support  mixed $aid 营销平台操作人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 东方美人删除用户
     *
     * @support  int $userId 用户id [ require true ]
     * @support  mixed $aid 营销平台操作人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 东方美人同步排名
     *
     * @support  int $aid 营销平台操作人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncRank () {
        return self::getClass()->syncRank();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'NewYearActivity\ActivityAdmin');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'NewYearActivity\ActivityAdmin');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}