<?php
namespace Mainto\Bridge\Invokes\HimoActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityLotteryInfoByParams(array $params)
 * @method runLotteryByParams(array $params)
 * @method getCouponRemainingByParams(array $params)
 * @method getCounponLottryByParams(array $params)
 * @method getFXLotteryByParams(array $params)
 */
class Lottery {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取抽奖信息详情
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivityLotteryInfo (string $activity_id) {
        return self::getClass()->getActivityLotteryInfo([
            "activity_id" => $activity_id,
        ]);
    }

    /**
     * 进行抽奖
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $round 抽奖轮次(默认为default) [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function runLottery (string $activity_id, string $round = 'default') {
        return self::getClass()->runLottery([
            "activity_id" => $activity_id,
            "round" => $round,
        ]);
    }

    /**
     * 查看时光之约的剩余优惠券
     *
     * @param  string $activity_id 活动ID , require=true [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getCouponRemaining (string $activity_id) {
        return self::getClass()->getCouponRemaining([
            "activity_id" => $activity_id,
        ]);
    }

    /**
     * 时光之约抽券
     *
     * @param  string $activity_id 活动ID , require=true [ require true ]
     * @param  string $phone 手机号码 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getCounponLottry (string $activity_id, string $phone, string $code) {
        return self::getClass()->getCounponLottry([
            "activity_id" => $activity_id,
            "phone" => $phone,
            "code" => $code,
        ]);
    }

    /**
     * 概率型抽奖
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $phone 手机号码 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getFXLottery (string $activity_id, string $phone) {
        return self::getClass()->getFXLottery([
            "activity_id" => $activity_id,
            "phone" => $phone,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'Lottery');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'Lottery');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}