<?php
namespace Mainto\Bridge\Invokes\HimoActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffsByParams(array $params)
 * @method staffInfoByParams(array $params)
 * @method captchaByParams(array $params)
 */
class Oa {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取员工信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffs () {
        return self::getClass()->getStaffs();
    }

    /**
     * 获取员工信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function staffInfo () {
        return self::getClass()->staffInfo();
    }

    /**
     * 获取验证码
     *
     * @support  string $mobile 电话 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function captcha () {
        return self::getClass()->captcha();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'Oa');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'Oa');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}