<?php
namespace Mainto\Bridge\Invokes\HimoActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method showActivityListByParams(array $params)
 * @method getActivityByParams(array $params)
 * @method editActivityByParams(array $params)
 * @method addActivityByParams(array $params)
 * @method deleteActivityByParams(array $params)
 * @method addActivityItemByParams(array $params)
 * @method editActivityItemByParams(array $params)
 * @method addRelationItemByParams(array $params)
 * @method editRelationItemByParams(array $params)
 * @method searchByParams(array $params)
 * @method fileDownloadGeneratorByParams(array $params)
 * @method searchRelationByParams(array $params)
 * @method deleteItemByParams(array $params)
 * @method restoreItemByParams(array $params)
 * @method addRelationNumByParams(array $params)
 * @method getRandomByParams(array $params)
 * @method setRandomCacheByParams(array $params)
 * @method cacheWechatInfoByParams(array $params)
 * @method getUpyunInfoByParams(array $params)
 * @method getUpyunHostByParams(array $params)
 * @method receiveAwardByParams(array $params)
 * @method getRemainCountByParams(array $params)
 */
class Activity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 显示当前活动列表
     *
     * @support  string $type 活动类型 
     * @param  int $limit 限制数目 [Original type uint] [ require true ]
     * @param  int $skip 跳过条目 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function showActivityList (int $skip = 0, int $limit = 40) {
        return self::getClass()->showActivityList([
            "skip" => $skip,
            "limit" => $limit,
        ]);
    }

    /**
     * getActivity
     *
     * @param  string $activityId 活动ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivity (string $activityId) {
        return self::getClass()->getActivity([
            "activityId" => $activityId,
        ]);
    }

    /**
     * 修改一个活动
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $type 活动类型 [ require true ]
     * @param  array $activity_payload 活动配置 [ require true ]
     * @param  array $activity_extend 活动拓展 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editActivity (string $activity_id, string $type = '', array $activity_payload = [], array $activity_extend = []) {
        return self::getClass()->editActivity([
            "activity_id" => $activity_id,
            "type" => $type,
            "activity_payload" => $activity_payload,
            "activity_extend" => $activity_extend,
        ]);
    }

    /**
     * 增加一个活动
     *
     * @support  string $name 活动名称 [ require true ]
     * @support  string $type 活动类型 [ require true ]
     * @support  array $payload 活动配置 [ require true ]
     * @support  array $extend 活动拓展 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addActivity () {
        return self::getClass()->addActivity();
    }

    /**
     * 删除一个活动
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteActivity (string $activity_id) {
        return self::getClass()->deleteActivity([
            "activity_id" => $activity_id,
        ]);
    }

    /**
     * 添加一个活动项目
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  array $activity_content 活动内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addActivityItem (string $activity_id, array $activity_content) {
        return self::getClass()->addActivityItem([
            "activity_id" => $activity_id,
            "activity_content" => $activity_content,
        ]);
    }

    /**
     * 修改一个活动项目
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $item_id 关联ID [ require true ]
     * @param  array $activity_content 活动内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editActivityItem (string $activity_id, string $item_id, array $activity_content) {
        return self::getClass()->editActivityItem([
            "activity_id" => $activity_id,
            "item_id" => $item_id,
            "activity_content" => $activity_content,
        ]);
    }

    /**
     * 添加一个活动关联项目
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $relation_id 关联ID [ require true ]
     * @param  string $relation_name 关联名称 [ require true ]
     * @param  array $relation_content 关联内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addRelationItem (string $activity_id, string $relation_id, string $relation_name, array $relation_content) {
        return self::getClass()->addRelationItem([
            "activity_id" => $activity_id,
            "relation_id" => $relation_id,
            "relation_name" => $relation_name,
            "relation_content" => $relation_content,
        ]);
    }

    /**
     * 修改一个活动关联项目
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $relation_name 关联名称 [ require true ]
     * @param  string $item_id 关联ID [ require true ]
     * @param  array $relation_content 活动内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRelationItem (string $activity_id, string $item_id, string $relation_name, array $relation_content) {
        return self::getClass()->editRelationItem([
            "activity_id" => $activity_id,
            "item_id" => $item_id,
            "relation_name" => $relation_name,
            "relation_content" => $relation_content,
        ]);
    }

    /**
     * 搜索接口（前台）
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @support  array $searchCond 搜索条件 
     * @support  array $with 合并条件 
     * @support  string $orderBy 排序条件 
     * @support  int $limit 限制数目 [Original type uint] 
     * @support  int $skip 跳过条目 [Original type uint] 
     * @support  bool $needRank 需要排名信息 
     * @support  bool $needLastItem 需要上一名信息 
     * @support  array $rankCond 排名条件 
     * @support  bool $includeDelete 包含删除内容 
     * @support  bool $count 获取数目 
     * @support  bool $withAward 获取获奖信息 
     * @support  bool $aggregation 聚合关联信息 
     * @support  array $excel 如果有该值，则导出为excel表格 
     * @throws  \Exception
     * @return  mixed
     */
    public static function search (string $activity_id) {
        return self::getClass()->search([
            "activity_id" => $activity_id,
        ]);
    }

    /**
     * 下载表格文件
     *
     * @param  string $excel_name 表格名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fileDownloadGenerator (string $excel_name) {
        return self::getClass()->fileDownloadGenerator([
            "excel_name" => $excel_name,
        ]);
    }

    /**
     * 搜索关联信息
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @support  array $with 合并条件 
     * @support  string $relationName 关联名称 [ require true ]
     * @support  array $searchCond 搜索条件 
     * @support  string $orderBy 排序条件 
     * @support  int $limit 限制数目 [Original type uint] 
     * @support  int $skip 跳过条目 [Original type uint] 
     * @support  bool $includeDelete 包含删除内容 
     * @support  bool $count 获取数目 
     * @support  bool $aggregation 聚合关联信息 
     * @support  int $aggregation_limit 聚合信息限制数目 [Original type uint] 
     * @support  int $aggregation_skip 集合信息跳过条目 [Original type uint] 
     * @support  array $excel 如果有该值，则导出为excel表格 
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchRelation (string $activity_id) {
        return self::getClass()->searchRelation([
            "activity_id" => $activity_id,
        ]);
    }

    /**
     * 删除一项
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $item_id 项目ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteItem (string $activity_id, string $item_id) {
        return self::getClass()->deleteItem([
            "activity_id" => $activity_id,
            "item_id" => $item_id,
        ]);
    }

    /**
     * 还原一项
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $item_id 项目ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function restoreItem (string $activity_id, string $item_id) {
        return self::getClass()->restoreItem([
            "activity_id" => $activity_id,
            "item_id" => $item_id,
        ]);
    }

    /**
     * 增加一个关联数目
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $relation_id 关联ID [ require true ]
     * @param  string $relation_name 关联名称 [ require true ]
     * @param  int $num 数目 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addRelationNum (string $activity_id, string $relation_name, string $relation_id, int $num) {
        return self::getClass()->addRelationNum([
            "activity_id" => $activity_id,
            "relation_name" => $relation_name,
            "relation_id" => $relation_id,
            "num" => $num,
        ]);
    }

    /**
     * 获取随机的一条记录
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  int $group_num 每批次数目 [Original type uint] [ require true ]
     * @param  int $random_num 要得到的数目 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRandom (string $activity_id, int $group_num = 0, int $random_num = 1) {
        return self::getClass()->getRandom([
            "activity_id" => $activity_id,
            "group_num" => $group_num,
            "random_num" => $random_num,
        ]);
    }

    /**
     * 设置随机记录缓存项
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  array $cache_content 更新内容 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setRandomCache (string $activity_id, array $cache_content = []) {
        return self::getClass()->setRandomCache([
            "activity_id" => $activity_id,
            "cache_content" => $cache_content,
        ]);
    }

    /**
     * 缓存微信登录信
     *
     * @param  string $tempToken 微信临时授权码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cacheWechatInfo (string $tempToken) {
        return self::getClass()->cacheWechatInfo([
            "tempToken" => $tempToken,
        ]);
    }

    /**
     * 获取又拍云相关信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunInfo () {
        return self::getClass()->getUpyunInfo();
    }

    /**
     * 获取又拍云host
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunHost () {
        return self::getClass()->getUpyunHost();
    }

    /**
     * 获取活动奖品
     *
     * @support  string $temp_token 微信临时授权码 [ require true ]
     * @support  string $activity_id 活动id [ require true ]
     * @support  string $phone 用户手机号 [ require true ]
     * @support  string $code 验证码 
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveAward () {
        return self::getClass()->receiveAward();
    }

    /**
     * 获取活动剩余可参加次数
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $relation_name 关联名称 [ require true ]
     * @param  array $relation_content 活动内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRemainCount (string $activity_id, string $relation_name, array $relation_content) {
        return self::getClass()->getRemainCount([
            "activity_id" => $activity_id,
            "relation_name" => $relation_name,
            "relation_content" => $relation_content,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'Activity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'Activity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}