<?php
namespace Mainto\Bridge\Invokes\HimoActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addGuardFairyActivityByParams(array $params)
 * @method getActivityIdByParams(array $params)
 * @method getActivityIdByOpenIdByParams(array $params)
 * @method checkSmsCodeByParams(array $params)
 * @method getActivityFairyInfoByParams(array $params)
 * @method getActivityGuardInfoByParams(array $params)
 * @method getUserPhotoByParams(array $params)
 * @method makeFairyPhotoByParams(array $params)
 * @method getAwardByParams(array $params)
 * @method guardFairyByParams(array $params)
 * @method getFairyPhotoByParams(array $params)
 * @method drawAwardByParams(array $params)
 * @method sendCouponByParams(array $params)
 * @method addActivityItemByParams(array $params)
 * @method addActivityRelationItemByParams(array $params)
 * @method deleteActivityItemByParams(array $params)
 * @method getInfoByParams(array $params)
 */
class GuardFairy {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 增加一批活动
     *
     * @param  string $name 活动名称 [ require true ]
     * @param  string $type 活动类型 [ require true ]
     * @param  array $payload 活动配置 [ require true ]
     * @param  array $extend 活动拓展 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addGuardFairyActivity (string $name, string $type, array $payload, array $extend) {
        return self::getClass()->addGuardFairyActivity([
            "name" => $name,
            "type" => $type,
            "payload" => $payload,
            "extend" => $extend,
        ]);
    }

    /**
     * 获取活动id配置
     *
     * @param  string $date 日期Y-m-d [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActivityId (string $date) {
        return self::getClass()->getActivityId([
            "date" => $date,
        ]);
    }

    /**
     * 获取活动id配置
     *
     * @support  string $open_id openid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActivityIdByOpenId () {
        return self::getClass()->getActivityIdByOpenId();
    }

    /**
     * 检验验证码
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @param  string $open_id 用户openId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkSmsCode (string $phone, string $code, string $open_id) {
        return self::getClass()->checkSmsCode([
            "phone" => $phone,
            "code" => $code,
            "open_id" => $open_id,
        ]);
    }

    /**
     * 获取排行榜数据
     *
     * @param  string $activity_day 活动日期Y-m-d [ require true ]
     * @param  string $open_id openid [ require true ]
     * @param  int $limit 显示条数 [Original type uint] [ require true ]
     * @param  int $skip 跳过 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActivityFairyInfo (string $activity_day, string $open_id, int $limit = 10, int $skip = 0) {
        return self::getClass()->getActivityFairyInfo([
            "activity_day" => $activity_day,
            "open_id" => $open_id,
            "limit" => $limit,
            "skip" => $skip,
        ]);
    }

    /**
     * 获取守护页面数据
     *
     * @param  string $activity_day 守护活动的日期 [ require true ]
     * @param  string $guard_open_id 守护者openid [ require true ]
     * @param  string $_id 仙女海报_id [ require true ]
     * @param  int $limit 条数 [Original type uint] [ require true ]
     * @param  int $skip 跳过条数 [Original type uint] [ require true ]
     * @param  string $fairy_open_id 仙女openId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActivityGuardInfo (string $activity_day, string $guard_open_id, string $_id = '', int $limit = 2000, int $skip = 0, string $fairy_open_id = '') {
        return self::getClass()->getActivityGuardInfo([
            "activity_day" => $activity_day,
            "guard_open_id" => $guard_open_id,
            "_id" => $_id,
            "limit" => $limit,
            "skip" => $skip,
            "fairy_open_id" => $fairy_open_id,
        ]);
    }

    /**
     * 获取仙女照
     *
     * @param  string $open_id openid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserPhoto (string $open_id) {
        return self::getClass()->getUserPhoto([
            "open_id" => $open_id,
        ]);
    }

    /**
     * 生成仙女照海报
     *
     * @param  string $photo_info 照片信息 [ require true ]
     * @param  array $wechat_info 用户微信信息 [ require true ]
     * @param  int $type 海报类型 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function makeFairyPhoto (string $photo_info, array $wechat_info, int $type) {
        return self::getClass()->makeFairyPhoto([
            "photo_info" => $photo_info,
            "wechat_info" => $wechat_info,
            "type" => $type,
        ]);
    }

    /**
     * 领取排行榜奖励
     *
     * @param  string $name 姓名 [ require true ]
     * @param  string $address 地址 [ require true ]
     * @param  string $activity_id 活动id [ require true ]
     * @param  string $_id id [ require true ]
     * @param  string $telephone phone [ require true ]
     * @param  array $wechat_info 微信信息 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getAward (string $name, string $address, string $activity_id, string $_id, array $wechat_info, string $telephone) {
        return self::getClass()->getAward([
            "name" => $name,
            "address" => $address,
            "activity_id" => $activity_id,
            "_id" => $_id,
            "wechat_info" => $wechat_info,
            "telephone" => $telephone,
        ]);
    }

    /**
     * 守护仙女
     *
     * @param  array $wechat_info 用户微信信息 [ require true ]
     * @param  string $activity_id 排行榜活动id [ require true ]
     * @param  string $activity_item_id 排行榜仙女的_id [ require true ]
     * @param  string $to_user 被守护者openid [ require true ]
     * @param  string $ticket 防水墙门票 [ require true ]
     * @param  string $randStr 随机str [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function guardFairy (array $wechat_info, string $activity_id, string $activity_item_id, string $to_user, string $ticket, string $randStr) {
        return self::getClass()->guardFairy([
            "wechat_info" => $wechat_info,
            "activity_id" => $activity_id,
            "activity_item_id" => $activity_item_id,
            "to_user" => $to_user,
            "ticket" => $ticket,
            "randStr" => $randStr,
        ]);
    }

    /**
     * 获取用户仙女照海报
     *
     * @param  string $fairy_open_id 用户openid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getFairyPhoto (string $fairy_open_id) {
        return self::getClass()->getFairyPhoto([
            "fairy_open_id" => $fairy_open_id,
        ]);
    }

    /**
     * 抽取惊喜福袋
     *
     * @param  array $wechat_info 微信信息 [ require true ]
     * @param  bool $advance 是否包含隐藏信息 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function drawAward (array $wechat_info, bool $advance = false) {
        return self::getClass()->drawAward([
            "wechat_info" => $wechat_info,
            "advance" => $advance,
        ]);
    }

    /**
     * 发放活动优惠券
     *
     * @param  string $open_id openid [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendCoupon (string $phone, string $open_id) {
        return self::getClass()->sendCoupon([
            "phone" => $phone,
            "open_id" => $open_id,
        ]);
    }

    /**
     * 参加全城庆
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  array $activity_content 活动内容 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addActivityItem (string $activity_id, array $activity_content, string $code) {
        return self::getClass()->addActivityItem([
            "activity_id" => $activity_id,
            "activity_content" => $activity_content,
            "code" => $code,
        ]);
    }

    /**
     * 投票
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $relation_id 关联ID [ require true ]
     * @param  string $relation_name 关联名称 [ require true ]
     * @param  array $relation_content 关联内容 [ require true ]
     * @param  string $ticket 防水墙门票 [ require true ]
     * @param  string $randStr 随机字符串 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addActivityRelationItem (string $activity_id, string $relation_id, string $relation_name, array $relation_content, string $ticket, string $randStr) {
        return self::getClass()->addActivityRelationItem([
            "activity_id" => $activity_id,
            "relation_id" => $relation_id,
            "relation_name" => $relation_name,
            "relation_content" => $relation_content,
            "ticket" => $ticket,
            "randStr" => $randStr,
        ]);
    }

    /**
     * 退出全城庆
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $item_id itemId [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function deleteActivityItem (string $activity_id, string $item_id) {
        return self::getClass()->deleteActivityItem([
            "activity_id" => $activity_id,
            "item_id" => $item_id,
        ]);
    }

    /**
     * 获取全城庆个人页面信息
     *
     * @param  string $activity_id 活动ID [ require true ]
     * @param  string $open_id 投票者openId [ require true ]
     * @param  string $to_user 被投票者openId [ require true ]
     * @param  string $limitName 限制的relation名,like guard [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $to_user, string $activity_id, string $limitName = 'guard', string $open_id = '') {
        return self::getClass()->getInfo([
            "to_user" => $to_user,
            "activity_id" => $activity_id,
            "limitName" => $limitName,
            "open_id" => $open_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoActivity', 'GuardFairy');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoActivity', 'GuardFairy');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}