<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-11 22:02:49
 */
namespace Mainto\Bridge\Invokes\FinanceBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class INbcbService
 * @method getGeneralDownloadUrlByParams(array $params) 通用宁波银行下载地址查询
 * @method pullNbcbReceiptByParams(array $params) 定时拉取宁波银行回单
 * @method pullNbcbReceiptDownloadNoByParams(array $params) 定时拉取宁波银行回单下载流水号
 * @method queryAccountByParams(array $params) 账户信息查询
 * @method getEleReceiptDownloadUrlByParams(array $params) 宁波银行回单下载地址查询
 * @method queryReceiptListByBankAccByParams(array $params) 宁波银行回单下载流水号查询
 * @method queryAccountDetailByParams(array $params) 账户明细查询
 */
class INbcbService {
    private static string $serviceName = "FinanceBill";

    private static string $className = "INbcbService";

    /**
     * 通用宁波银行下载地址查询
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Nbcb\NbcbDownLoadUrlDTO
    */
    public static function getGeneralDownloadUrl () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getGeneralDownloadUrl(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Nbcb\NbcbDownLoadUrlDTO"
        );
    }

    /**
     * 定时拉取宁波银行回单
     * @return  void
    */
    public static function pullNbcbReceipt () {
         RpcClass::getClass(self::$serviceName, self::$className)->pullNbcbReceipt();
    }

    /**
     * 定时拉取宁波银行回单下载流水号
     * @return  void
    */
    public static function pullNbcbReceiptDownloadNo () {
         RpcClass::getClass(self::$serviceName, self::$className)->pullNbcbReceiptDownloadNo();
    }

    /**
     * 账户信息查询
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Nbcb\NbcbQueryAccountDTO
    */
    public static function queryAccount (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Nbcb\NbcbQueryAccountRequest $nbcbQueryAccountRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryAccount($nbcbQueryAccountRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Nbcb\NbcbQueryAccountDTO"
        );
    }

    /**
     * 宁波银行回单下载地址查询
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Nbcb\NbcbGetEleReceiptDownloadUrlDTO
    */
    public static function getEleReceiptDownloadUrl (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Nbcb\NbcbGetEleReceiptDownloadUrlRequest $nbcbGetEleReceiptDownloadUrlRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getEleReceiptDownloadUrl($nbcbGetEleReceiptDownloadUrlRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Nbcb\NbcbGetEleReceiptDownloadUrlDTO"
        );
    }

    /**
     * 宁波银行回单下载流水号查询
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Nbcb\NbcbQueryReceiptListByBankAccDTO
    */
    public static function queryReceiptListByBankAcc (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Nbcb\NbcbQueryReceiptListByBankAccRequest $nbcbQueryReceiptListByBankAccRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryReceiptListByBankAcc($nbcbQueryReceiptListByBankAccRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Nbcb\NbcbQueryReceiptListByBankAccDTO"
        );
    }

    /**
     * 账户明细查询
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Nbcb\NbcbBankAccountDetailDTO
    */
    public static function queryAccountDetail (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Nbcb\NbcbBankAccountDetailQueryRequest $nbcbBankAccountDetailQueryRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryAccountDetail($nbcbBankAccountDetailQueryRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Nbcb\NbcbBankAccountDetailDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}