<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-02 13:51:04
 */
namespace Mainto\Bridge\Invokes\FinanceBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class IBankReceiptService
 * @method pullBankReceiptManualByParams(array $params) 手动获取保融银行回单
 * @method bankReceiptPageListByParams(array $params) 银行回单列表-分页
 * @method updateBankReceiptFileUrlByParams(array $params) 手动上传银行回单
 * @method bankReceiptFlowMarkManualByParams(array $params) 手动流水打标
 * @method bankReceiptDetailByParams(array $params) 银行回单明细详情
 */
class IBankReceiptService {
    private static string $serviceName = "FinanceBill";

    private static string $className = "IBankReceiptService";

    /**
     * 手动获取保融银行回单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function pullBankReceiptManual () {
        return RpcClass::getClass(self::$serviceName, self::$className)->pullBankReceiptManual([]);
    }

    /**
     * 银行回单列表-分页
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BankReceipt\BankReceiptListPageDTO
    */
    public static function bankReceiptPageList (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\BankReceipt\PageQueryBankReceiptRequest $pageQueryBankReceiptRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bankReceiptPageList($pageQueryBankReceiptRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BankReceipt\BankReceiptListPageDTO"
        );
    }

    /**
     * 手动上传银行回单
     * @return  bool
    */
    public static function updateBankReceiptFileUrl (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\BankReceipt\UpdateBankReceiptFileUrlRequest $updateBankReceiptFileUrlRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateBankReceiptFileUrl($updateBankReceiptFileUrlRequest);
    }

    /**
     * 手动流水打标
     * @return  bool
    */
    public static function bankReceiptFlowMarkManual (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\BankReceipt\BankReceiptFlowMarkRequest $bankReceiptFlowMarkRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankReceiptFlowMarkManual($bankReceiptFlowMarkRequest);
    }

    /**
     * 银行回单明细详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BankReceipt\BankReceiptDetailDTO
    */
    public static function bankReceiptDetail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bankReceiptDetail([]),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BankReceipt\BankReceiptDetailDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}