<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-28 14:40:18
 */
namespace Mainto\Bridge\Invokes\FinanceBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class KingdeeSearchService
 * @method searchCostBelongByParams(array $params) 获取费用归属项目列表
 * @method searchPurposeByParams(array $params) 获取收付款用途列表
 * @method searchIntermediaryByParams(array $params) 获取中介服务机构列表
 * @method searchRelatedPartyByParams(array $params) 获取关联方列表
 * @method searchStaffByParams(array $params) 获取员工列表
 * @method searchSubsidyProjectByParams(array $params) 获取补贴项目列表
 * @method searchOrganizationByParams(array $params) 获取主体列表
 * @method searchCustomerByParams(array $params) 获取客户列表
 * @method searchFranchiseeByParams(array $params) 获取加盟商列表
 * @method searchDepartmentByParams(array $params) 获取部门列表
 * @method searchSupplierByParams(array $params) 获取供应商列表
 * @method searchDpProjectByParams(array $params) 获取研发项目
 * @method searchSettleMethodByParams(array $params) 获取结算方式列表
 * @method searchFinancialInstitutionByParams(array $params) 获取金融机构列表
 * @method searchDepositTypeByParams(array $params) 获取押金保证金类别列表
 * @method searchBankByParams(array $params) 获取银行列表
 * @method searchManageProjectByParams(array $params) 获取理财项目列表
 * @method searchBranchCompanyByParams(array $params) 获取分公司列表
 * @method searchBusinessModeByParams(array $params) 获取业务模式
 * @method searchDocumentTypeByParams(array $params) 通过单据名称获取单据类型
 * @method searchCostProjectByParams(array $params) 获取费用项目列表
 */
class KingdeeSearchService {
    private static string $serviceName = "FinanceBill";

    private static string $className = "KingdeeSearchService";

    /**
     * 获取费用归属项目列表
     * @return  array
    */
    public static function searchCostBelong () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchCostBelong(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取收付款用途列表
     * @return  array
    */
    public static function searchPurpose () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchPurpose(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取中介服务机构列表
     * @return  array
    */
    public static function searchIntermediary () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchIntermediary(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取关联方列表
     * @return  array
    */
    public static function searchRelatedParty () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchRelatedParty(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取员工列表
     * @return  array
    */
    public static function searchStaff () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchStaff(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取补贴项目列表
     * @return  array
    */
    public static function searchSubsidyProject () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchSubsidyProject(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取主体列表
     * @return  array
    */
    public static function searchOrganization () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchOrganization(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取客户列表
     * @return  array
    */
    public static function searchCustomer () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchCustomer(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取加盟商列表
     * @return  array
    */
    public static function searchFranchisee () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchFranchisee(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取部门列表
     * @return  array
    */
    public static function searchDepartment () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchDepartment(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取供应商列表
     * @return  array
    */
    public static function searchSupplier () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchSupplier(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取研发项目
     * @return  array
    */
    public static function searchDpProject () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchDpProject(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取结算方式列表
     * @return  array
    */
    public static function searchSettleMethod () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchSettleMethod(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取金融机构列表
     * @return  array
    */
    public static function searchFinancialInstitution () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchFinancialInstitution(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取押金保证金类别列表
     * @return  array
    */
    public static function searchDepositType () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchDepositType(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取银行列表
     * @return  array
    */
    public static function searchBank () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchBank(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取理财项目列表
     * @return  array
    */
    public static function searchManageProject () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchManageProject(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取分公司列表
     * @return  array
    */
    public static function searchBranchCompany () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchBranchCompany(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取业务模式
     * @return  array
    */
    public static function searchBusinessMode () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchBusinessMode(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 通过单据名称获取单据类型
     * @return  array
    */
    public static function searchDocumentType () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchDocumentType(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }
    /**
     * 获取费用项目列表
     * @return  array
    */
    public static function searchCostProject () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchCostProject(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Kingdee\SearchCommonDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}