<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-28 14:40:18
 */
namespace Mainto\Bridge\Invokes\FinanceBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class IClaimFlowService
 * @method alipayFlowClaimByParams(array $params) 先胜支付宝流水认领
 * @method addManualClaimByParams(array $params) 对流水进行手工认领——常规
 * @method saveClaimFlowSettingByParams(array $params) 新增/修改流水认领配置
 * @method claimFlowDetailByParams(array $params) 手工流水认领主表详情
 * @method addClaimFlowWelfareByParams(array $params) 新增社保公积金明细
 * @method delClaimFlowWelfareByParams(array $params) 根据父级id全量删除公积金明细
 * @method claimFlowSalaryPageListByParams(array $params) 手工流水认领薪酬分页列表
 * @method addClaimFlowSalaryByParams(array $params) 新增薪资明细
 * @method claimFlowPageListByParams(array $params) 手工流水认领列表
 * @method claimFlowSettingDetailByParams(array $params) 流水认领配置详情
 * @method addWelfareClaimByParams(array $params) 对流水进行手工认领——社保公积金
 * @method claimFlowWelfarePageListByParams(array $params) 手工流水认领公积金分页列表
 * @method claimFlowSettingPageListByParams(array $params) 流水认领场景列表-分页
 * @method claimFlowCommonPageListByParams(array $params) 手工流水认领常规分页列表
 * @method flowRemarkByParams(array $params) 对未认领的流水进行打标
 * @method bankFlowClaimByParams(array $params) 先胜银行流水认领
 * @method updateClaimFlowByParams(array $params) 更新手工流水主表
 * @method addSalaryClaimByParams(array $params) 对流水进行手工认领——薪资
 * @method delClaimFlowSalaryByParams(array $params) 根据父级id全量删除薪资明细
 * @method updateClaimFlowCommonByParams(array $params) 更新手工流水通用列表
 * @method billFlowClaimByParams(array $params) 付款单流水认领
 */
class IClaimFlowService {
    private static string $serviceName = "FinanceBill";

    private static string $className = "IClaimFlowService";

    /**
     * 先胜支付宝流水认领
     * @return  bool
    */
    public static function alipayFlowClaim (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\SearchDateRequest $searchDateRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->alipayFlowClaim($searchDateRequest);
    }
    /**
     * 对流水进行手工认领——常规
     * @return  bool
    */
    public static function addManualClaim (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\AddManualClaimRequest $addManualClaimRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addManualClaim($addManualClaimRequest);
    }
    /**
     * 新增/修改流水认领配置
     * @return  bool
    */
    public static function saveClaimFlowSetting (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\SaveClaimFlowSettingRequest $saveClaimFlowSettingRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveClaimFlowSetting($saveClaimFlowSettingRequest);
    }
    /**
     * 手工流水认领主表详情
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\ClaimFlowDTO
    */
    public static function claimFlowDetail (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\IdRequest $idRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->claimFlowDetail($idRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\ClaimFlowDTO"
        );
    }
    /**
     * 新增社保公积金明细
     * @return  bool
    */
    public static function addClaimFlowWelfare (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\AddFlowWelfareListRequest $addFlowWelfareListRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addClaimFlowWelfare($addFlowWelfareListRequest);
    }
    /**
     * 根据父级id全量删除公积金明细
     * @return  bool
    */
    public static function delClaimFlowWelfare (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\IdRequest $idRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delClaimFlowWelfare($idRequest);
    }
    /**
     * 手工流水认领薪酬分页列表
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\ClaimFlowSalaryListPageDTO
    */
    public static function claimFlowSalaryPageList (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\PageFlowCommonRequest $pageFlowCommonRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->claimFlowSalaryPageList($pageFlowCommonRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\ClaimFlowSalaryListPageDTO"
        );
    }
    /**
     * 新增薪资明细
     * @return  bool
    */
    public static function addClaimFlowSalary (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\AddFlowSalaryListRequest $addFlowSalaryListRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addClaimFlowSalary($addFlowSalaryListRequest);
    }
    /**
     * 手工流水认领列表
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\ClaimFlowListPageDTO
    */
    public static function claimFlowPageList (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\PageClaimFlowRequest $pageClaimFlowRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->claimFlowPageList($pageClaimFlowRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\ClaimFlowListPageDTO"
        );
    }
    /**
     * 流水认领配置详情
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\FlowSettingDetailDTO
    */
    public static function claimFlowSettingDetail (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\IdRequest $idRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->claimFlowSettingDetail($idRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\FlowSettingDetailDTO"
        );
    }
    /**
     * 对流水进行手工认领——社保公积金
     * @return  bool
    */
    public static function addWelfareClaim (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\AddManualClaimRequest $addManualClaimRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addWelfareClaim($addManualClaimRequest);
    }
    /**
     * 手工流水认领公积金分页列表
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\ClaimFlowWelfareListPageDTO
    */
    public static function claimFlowWelfarePageList (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\PageFlowCommonRequest $pageFlowCommonRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->claimFlowWelfarePageList($pageFlowCommonRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\ClaimFlowWelfareListPageDTO"
        );
    }
    /**
     * 流水认领场景列表-分页
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\FlowSettingListPageDTO
    */
    public static function claimFlowSettingPageList (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\PageQueryFlowSettingRequest $pageQueryFlowSettingRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->claimFlowSettingPageList($pageQueryFlowSettingRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\FlowSettingListPageDTO"
        );
    }
    /**
     * 手工流水认领常规分页列表
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\ClaimFlowCommonListPageDTO
    */
    public static function claimFlowCommonPageList (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\PageFlowCommonRequest $pageFlowCommonRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->claimFlowCommonPageList($pageFlowCommonRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\Claim\ClaimFlowCommonListPageDTO"
        );
    }
    /**
     * 对未认领的流水进行打标
     * @return  bool
    */
    public static function flowRemark (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\SearchDateRequest $searchDateRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->flowRemark($searchDateRequest);
    }
    /**
     * 先胜银行流水认领
     * @return  bool
    */
    public static function bankFlowClaim (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\SearchDateRequest $searchDateRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankFlowClaim($searchDateRequest);
    }
    /**
     * 更新手工流水主表
     * @return  bool
    */
    public static function updateClaimFlow (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\UpdateFlowRequest $updateFlowRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateClaimFlow($updateFlowRequest);
    }
    /**
     * 对流水进行手工认领——薪资
     * @return  bool
    */
    public static function addSalaryClaim (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\AddManualClaimRequest $addManualClaimRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addSalaryClaim($addManualClaimRequest);
    }
    /**
     * 根据父级id全量删除薪资明细
     * @return  bool
    */
    public static function delClaimFlowSalary (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\IdRequest $idRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delClaimFlowSalary($idRequest);
    }
    /**
     * 更新手工流水通用列表
     * @return  bool
    */
    public static function updateClaimFlowCommon (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\UpdateFlowCommonListRequest $updateFlowCommonListRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateClaimFlowCommon($updateFlowCommonListRequest);
    }
    /**
     * 付款单流水认领
     * @return  bool
    */
    public static function billFlowClaim (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\Claim\SearchDateRequest $searchDateRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->billFlowClaim($searchDateRequest);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}