<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-20 17:25:27
 */
namespace Mainto\Bridge\Invokes\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Biz\Controller;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class BankReceiptCronController
 */
class BankReceiptCronController {
    private static string $serviceName = "FinanceBill";

    private static string $className = "com.mainto.earthen.finance.bill.biz.controller.BankReceiptCronController";

    /**
     * 按照交易时间区间，对银行回单打标
     * @return  bool
    */
    public static function flowMarkManual (string $tradeAtStart, string $tradeAtEnd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->flowMarkManual(["tradeAtStart" => $tradeAtStart, "tradeAtEnd" => $tradeAtEnd]);
    }
    /**
     * 将非保融账单历史数据刷到银行回单表。一次性任务，上线完毕后删除
     * @return  bool
    */
    public static function syncBankStatementBillToBankReceiptOnce () {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncBankStatementBillToBankReceiptOnce();
    }
    /**
     * 根据回单的银行流水ids，查询保融的银行回单
     * @return  bool
    */
    public static function pullFingardBankReceiptByBankFlowNoList (array $bankFlowNoList) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pullFingardBankReceiptByBankFlowNoList(["bankFlowNoList" => $bankFlowNoList]);
    }
    /**
     * 每天7:30，12:30，22:30点，定时对保融流水打标
     * @return  bool
    */
    public static function flowMarkCron () {
        return RpcClass::getClass(self::$serviceName, self::$className)->flowMarkCron();
    }
    /**
     * 将保融账单历史数据刷到银行回单表。一次性任务，上线完毕后删除
     * @return  bool
    */
    public static function syncFinagardV2BillToBankReceiptOnce () {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncFinagardV2BillToBankReceiptOnce();
    }
    /**
     * 按照交易时间区间，拉取保融银行回单
     * @return  bool
    */
    public static function pullFingardBankReceiptManual (string $tradeAtStart, string $tradeAtEnd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pullFingardBankReceiptManual(["tradeAtStart" => $tradeAtStart, "tradeAtEnd" => $tradeAtEnd]);
    }
    /**
     * 每天7，12，22点，定时拉取保融银行回单
     * @return  bool
    */
    public static function pullFingardBankReceiptCron () {
        return RpcClass::getClass(self::$serviceName, self::$className)->pullFingardBankReceiptCron();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}