<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-02-27 10:38:41
 */
namespace Mainto\Bridge\Invokes\FinanceBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class IBillAccountService
 */
class IBillAccountService {
    private static string $serviceName = "FinanceBill";

    private static string $className = "IBillAccountService";

    /**
     * 根据账单取代id查询账单类型列表
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillTypeListDTO
    */
    public static function queryBillTypeListByBillChannelId (int $billChannelId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryBillTypeListByBillChannelId(["billChannelId" => $billChannelId]),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillTypeListDTO"
        );
    }
    /**
     * 根据账单渠道id查询账单账号列表
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillAccountListDTO
    */
    public static function queryBillAccountListByBillChannelId (int $billChannelId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryBillAccountListByBillChannelId(["billChannelId" => $billChannelId]),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillAccountListDTO"
        );
    }
    /**
     * 账单渠道列表
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillChannelListDTO
    */
    public static function queryBillChannelList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryBillChannelList(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillChannelListDTO"
        );
    }
    /**
     * 根据账单账号id查询账单账号详情
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillAccountDetailDTO
    */
    public static function queryBillAccountDetailById (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryBillAccountDetailById(["id" => $id]),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillAccountDetailDTO"
        );
    }
    /**
     * 账单类型列表
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillTypeListDTO
    */
    public static function queryBillTypeList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryBillTypeList(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillTypeListDTO"
        );
    }
    /**
     * 账单账号列表-不分页
     * @return  array
    */
    public static function queryBillAccount (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\BillAccount\QueryBillAccountRequest $queryBillAccountRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryBillAccount($queryBillAccountRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillAccountDetailDTO[]"
        );
    }
    /**
     * 账单账号列表
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillAccountListDTO
    */
    public static function queryBillAccountList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryBillAccountList(),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillAccountListDTO"
        );
    }
    /**
     * 更新账单账号
     * @return  bool
    */
    public static function updateBillAccount (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\BillAccount\UpdateBillAccountRequest $updateBillAccountRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateBillAccount($updateBillAccountRequest);
    }
    /**
     * 根据账单渠道id查询账单渠道
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillChannelDTO
    */
    public static function queryBillChannelById (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryBillChannelById(["id" => $id]),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillChannelDTO"
        );
    }
    /**
     * 创建账单账号
     * @return  bool
    */
    public static function createBillAccount (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\BillAccount\CreateBillAccountRequest $createBillAccountRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createBillAccount($createBillAccountRequest);
    }
    /**
     * 账单账号列表-分页
     * @return  \Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillAccountListPageDTO
    */
    public static function pageQueryBillAccount (?\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Request\BillAccount\PageQueryBillAccountRequest $pageQueryBillAccountRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->pageQueryBillAccount($pageQueryBillAccountRequest),
            "\Mainto\Bridge\Structs\FinanceBill\Com\Mainto\Earthen\Finance\Bill\Api\Response\BillAccount\BillAccountListPageDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}