<?php
namespace Mainto\Bridge\Invokes\FileSystem;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getHostByParams(array $params)
 * @method getHostInitPrefixByParams(array $params)
 * @method getTokenByParams(array $params)
 * @method getUploadInfoByParams(array $params)
 * @method changeMetaByParams(array $params)
 * @method getMetaByParams(array $params)
 * @method pfopWithCallBackByParams(array $params)
 * @method deleteByParams(array $params)
 * @method putByParams(array $params)
 * @method uploadBinaryFileByBase64ByParams(array $params)
 * @method uploadBinaryFileByBase64SpecifyNameByParams(array $params)
 * @method hookPhotoMetaTagsByParams(array $params)
 */
class Qiniu {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取七牛云host
     *
     * @param  string $project project [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost (string $project) {
        return self::getClass()->getHost([
            "project" => $project,
        ]);
    }

    /**
     * 获取七牛云hostInitPrefix
     *
     * @param  string $project project [ require true ]
     * @param  bool $withHost 是否需要host [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHostInitPrefix (string $project, bool $withHost = false) {
        return self::getClass()->getHostInitPrefix([
            "project" => $project,
            "withHost" => $withHost,
        ]);
    }

    /**
     * 获取七牛云签名
     *
     * @param  string $project project [ require true ]
     * @param  array $persistentOps 预处理操作集 [ require false ]
     * @param  string $dirRule dirRule [ require false ]
     * @param  string $pipeline 预处理队列 [ require false ]
     * @param  string $key 指定key [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getToken (string $project, array $persistentOps = [], string $dirRule = 'default', string $pipeline = 'default', string $key = null) {
        return self::getClass()->getToken([
            "project" => $project,
            "persistentOps" => $persistentOps,
            "dirRule" => $dirRule,
            "pipeline" => $pipeline,
            "key" => $key,
        ]);
    }

    /**
     * 获取七牛云上传信息
     *
     * @param  string $project project [ require true ]
     * @param  string $persistentOps 预处理操作集 [ require false ]
     * @param  string $dirRule dirRule [ require false ]
     * @param  string $pipeline 预处理队列 [ require false ]
     * @param  string $key 指定key [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUploadInfo (string $project, string $persistentOps = '', string $dirRule = 'default', string $pipeline = 'default', string $key = null) {
        return self::getClass()->getUploadInfo([
            "project" => $project,
            "persistentOps" => $persistentOps,
            "dirRule" => $dirRule,
            "pipeline" => $pipeline,
            "key" => $key,
        ]);
    }

    /**
     * changeMeta
     *
     * @param  string $project project [ require true ]
     * @param  string $key key [ require true ]
     * @param  array $metas metas [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeMeta (string $project, string $key, array $metas) {
        return self::getClass()->changeMeta([
            "project" => $project,
            "key" => $key,
            "metas" => $metas,
        ]);
    }

    /**
     * getMeta
     *
     * @param  string $project project [ require true ]
     * @param  string $key key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMeta (string $project, string $key) {
        return self::getClass()->getMeta([
            "project" => $project,
            "key" => $key,
        ]);
    }

    /**
     * 文件异步处理并回调
     *
     * @param  string $project project [ require true ]
     * @param  string $key key [ require true ]
     * @param  string $fop 操作集 [ require true ]
     * @param  string $notifyUrl 异步通知Url [ require true ]
     * @param  string $dirRule 文件规则 [ require false ]
     * @param  string $pipeline 队列名 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pfopWithCallBack (string $project, string $key, string $fop, string $notifyUrl, string $dirRule = 'default', string $pipeline = 'default') {
        return self::getClass()->pfopWithCallBack([
            "project" => $project,
            "key" => $key,
            "fop" => $fop,
            "notifyUrl" => $notifyUrl,
            "dirRule" => $dirRule,
            "pipeline" => $pipeline,
        ]);
    }

    /**
     * 资源删除
     *
     * @param  string $project project [ require true ]
     * @param  string $key key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $project, string $key) {
        return self::getClass()->delete([
            "project" => $project,
            "key" => $key,
        ]);
    }

    /**
     * 资源上传
     *
     * @param  string $project project [ require true ]
     * @param  string $dirRule dirRule [ require false ]
     * @param  string $key 指定key [ require false ]
     * @param  string $filePath 文件路径 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function put (string $project, string $filePath, string $dirRule = 'default', string $key = null) {
        return self::getClass()->put([
            "project" => $project,
            "filePath" => $filePath,
            "dirRule" => $dirRule,
            "key" => $key,
        ]);
    }

    /**
     * 传递base64字符串转化为二进制文件上传
     *
     * @param  string $project project [ require true ]
     * @param  string $dirRule dirRule [ require false ]
     * @param  array $contents base64字符串和文件类型的数组,doc=&gt;MADFG/kk [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function uploadBinaryFileByBase64 (string $project, array $contents, string $dirRule = 'default') {
        return self::getClass()->uploadBinaryFileByBase64([
            "project" => $project,
            "contents" => $contents,
            "dirRule" => $dirRule,
        ]);
    }

    /**
     * 传递base64字符串转化为二进制文件上传并指定文件名
     *
     * @param  string $project project [ require true ]
     * @param  string $dirRule dirRule [ require false ]
     * @param  array $contents base64字符串和文件类型，文件名的数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function uploadBinaryFileByBase64SpecifyName (string $project, array $contents, string $dirRule = 'default') {
        return self::getClass()->uploadBinaryFileByBase64SpecifyName([
            "project" => $project,
            "contents" => $contents,
            "dirRule" => $dirRule,
        ]);
    }

    /**
     * hook图片七牛云标签
     *
     * @param  string $project 项目 [ require true ]
     * @param  mixed $photoMetas photoMeta [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookPhotoMetaTags (string $project, $photoMetas) {
        return self::getClass()->hookPhotoMetaTags([
            "project" => $project,
            "photoMetas" => $photoMetas,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FileSystem', 'Qiniu');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FileSystem', 'Qiniu');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}