<?php
namespace Mainto\Bridge\Invokes\FileSystem;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTopFeatureByImageByParams(array $params)
 * @method processMarkImageByParams(array $params)
 */
class ImageAlgorithm {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * topN图片
     *
     * @param  string $imageKey imageKey [ require true ]
     * @param  int $topN topN [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTopFeatureByImage (string $imageKey, int $topN = 5) {
        return self::getClass()->getTopFeatureByImage([
            "imageKey" => $imageKey,
            "topN" => $topN,
        ]);
    }

    /**
     * 照片打水印
     *
     * @param  string $imagePath 照片路径 [ require true ]
     * @param  string $markType 水印类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function processMarkImage (string $imagePath, string $markType = 'other') {
        return self::getClass()->processMarkImage([
            "imagePath" => $imagePath,
            "markType" => $markType,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FileSystem', 'ImageAlgorithm');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FileSystem', 'ImageAlgorithm');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}