<?php
namespace Mainto\Bridge\Invokes\FileSystem;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getHostByParams(array $params)
 * @method getHostInitPrefixByParams(array $params)
 * @method getTokenByParams(array $params)
 * @method getUploadInfoByParams(array $params)
 * @method changeMetaByParams(array $params)
 * @method getMetaByParams(array $params)
 * @method pfopWithCallBackByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Qiniu {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取七牛云host
     *
     * @param  string $project project [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getHost (string $project) {
        return self::getClass()->getHost([
            "project" => $project,
        ]);
    }

    /**
     * 获取七牛云hostInitPrefix
     *
     * @param  string $project project [ require true ]
     * @param  bool $withHost 是否需要host [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHostInitPrefix (string $project, bool $withHost = false) {
        return self::getClass()->getHostInitPrefix([
            "project" => $project,
            "withHost" => $withHost,
        ]);
    }

    /**
     * 获取七牛云签名
     *
     * @param  string $project project [ require true ]
     * @param  array $persistentOps 预处理操作集 [ require true ]
     * @param  string $dirRule dirRule [ require true ]
     * @param  string $pipeline 预处理队列 [ require true ]
     * @param  string $key 指定key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getToken (string $project, array $persistentOps = [], string $dirRule = 'default', string $pipeline = 'default', string $key = NULL) {
        return self::getClass()->getToken([
            "project" => $project,
            "persistentOps" => $persistentOps,
            "dirRule" => $dirRule,
            "pipeline" => $pipeline,
            "key" => $key,
        ]);
    }

    /**
     * 获取七牛云上传信息
     *
     * @param  string $project project [ require true ]
     * @param  string $persistentOps 预处理操作集 [ require true ]
     * @param  string $dirRule dirRule [ require true ]
     * @param  string $pipeline 预处理队列 [ require true ]
     * @param  string $key 指定key [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUploadInfo (string $project, string $persistentOps = '', string $dirRule = 'default', string $pipeline = 'default', string $key = NULL) {
        return self::getClass()->getUploadInfo([
            "project" => $project,
            "persistentOps" => $persistentOps,
            "dirRule" => $dirRule,
            "pipeline" => $pipeline,
            "key" => $key,
        ]);
    }

    /**
     * changeMeta
     *
     * @param  string $project project [ require true ]
     * @param  string $key key [ require true ]
     * @param  array $metas metas [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeMeta (string $project, string $key, array $metas) {
        return self::getClass()->changeMeta([
            "project" => $project,
            "key" => $key,
            "metas" => $metas,
        ]);
    }

    /**
     * getMeta
     *
     * @param  string $project project [ require true ]
     * @param  string $key key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMeta (string $project, string $key) {
        return self::getClass()->getMeta([
            "project" => $project,
            "key" => $key,
        ]);
    }

    /**
     * 文件异步处理并回调
     *
     * @param  string $project project [ require true ]
     * @param  string $key key [ require true ]
     * @param  string $fop 操作集 [ require true ]
     * @param  string $notifyUrl 异步通知Url [ require true ]
     * @param  string $dirRule 文件规则 [ require true ]
     * @param  string $pipeline 队列名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pfopWithCallBack (string $project, string $key, string $fop, string $notifyUrl, string $dirRule = 'default', string $pipeline = 'default') {
        return self::getClass()->pfopWithCallBack([
            "project" => $project,
            "key" => $key,
            "fop" => $fop,
            "notifyUrl" => $notifyUrl,
            "dirRule" => $dirRule,
            "pipeline" => $pipeline,
        ]);
    }

    /**
     * 资源删除
     *
     * @param  string $project project [ require true ]
     * @param  string $key key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $project, string $key) {
        return self::getClass()->delete([
            "project" => $project,
            "key" => $key,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FileSystem', 'Qiniu');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FileSystem', 'Qiniu');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}