<?php
namespace Mainto\Bridge\Invokes\FileSystem;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTopFeatureByImageByParams(array $params)
 * @method imageAutoProcessByParams(array $params)
 */
class ImageAlgorithm {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * topN图片
     *
     * @param  string $imageKey imageKey [ require true ]
     * @param  int $topN topN [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTopFeatureByImage (string $imageKey, int $topN = 5) {
        return self::getClass()->getTopFeatureByImage([
            "imageKey" => $imageKey,
            "topN" => $topN,
        ]);
    }

    /**
     * 自动处理图片
     *
     * @param  string $key 图片key [ require true ]
     * @param  string $processFlag 自动修图功能选择 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function imageAutoProcess (string $key, string $processFlag) {
        return self::getClass()->imageAutoProcess([
            "key" => $key,
            "processFlag" => $processFlag,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FileSystem', 'ImageAlgorithm');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FileSystem', 'ImageAlgorithm');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}