<?php
namespace Mainto\Bridge\Invokes\FileSystem;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getHostByParams(array $params)
 * @method getHostInitPrefixByParams(array $params)
 * @method getTokenByParams(array $params)
 * @method changeMetaByParams(array $params)
 * @method getMetaByParams(array $params)
 */
class Qiniu {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取七牛云host
     *
     * @param  string $project project [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getHost (string $project) {
        return self::getClass()->getHost([
            "project" => $project,
        ]);
    }

    /**
     * 获取七牛云hostInitPrefix
     *
     * @param  string $project project [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHostInitPrefix (string $project) {
        return self::getClass()->getHostInitPrefix([
            "project" => $project,
        ]);
    }

    /**
     * 获取七牛云签名
     *
     * @param  string $project project [ require true ]
     * @param  array $persistentOps 预处理操作集 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getToken (string $project, array $persistentOps = []) {
        return self::getClass()->getToken([
            "project" => $project,
            "persistentOps" => $persistentOps,
        ]);
    }

    /**
     * changeMeta
     *
     * @param  string $project project [ require true ]
     * @param  string $key key [ require true ]
     * @param  array $metas metas [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeMeta (string $project, string $key, array $metas) {
        return self::getClass()->changeMeta([
            "project" => $project,
            "key" => $key,
            "metas" => $metas,
        ]);
    }

    /**
     * getMeta
     *
     * @param  string $project project [ require true ]
     * @param  string $key key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMeta (string $project, string $key) {
        return self::getClass()->getMeta([
            "project" => $project,
            "key" => $key,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FileSystem', 'Qiniu');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FileSystem', 'Qiniu');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}