<?php
namespace Mainto\Bridge\Invokes\FileSystem;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method newUpyunConfigByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 * @method getHostPrefixByParams(array $params)
 * @method getHostByParams(array $params)
 */
class Upyun {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * newUpyunConfig
     *
     * @param  string $upyun_key upyun_key [ require true ]
     * @param  string $prefix 路径 [ require true ]
     * @param  string $save_key 保存key [ require true ]
     * @param  string $bucket 空间名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function newUpyunConfig (string $upyun_key, string $prefix, string $save_key, string $bucket) {
        return self::getClass()->newUpyunConfig([
            "upyun_key" => $upyun_key,
            "prefix" => $prefix,
            "save_key" => $save_key,
            "bucket" => $bucket,
        ]);
    }

    /**
     * 获取又拍云上传签名
     *
     * @param  string $upyun_key key [ require true ]
     * @param  bool $isDown key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign (string $upyun_key, bool $isDown = false) {
        return self::getClass()->getUpyunSign([
            "upyun_key" => $upyun_key,
            "isDown" => $isDown,
        ]);
    }

    /**
     * 获取又拍云host-prefix
     *
     * @param  string $upyun_key key [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getHostPrefix (string $upyun_key) {
        return self::getClass()->getHostPrefix([
            "upyun_key" => $upyun_key,
        ]);
    }

    /**
     * 获取又拍云host
     *
     * @param  string $upyun_key key [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getHost (string $upyun_key) {
        return self::getClass()->getHost([
            "upyun_key" => $upyun_key,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FileSystem', 'Upyun');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FileSystem', 'Upyun');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}