<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-05 23:27:24
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\NAS;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RetainPhotoOrder
 * @method listByParams(array $params) 获取门店保留底片操作记录
 * @method cancelByParams(array $params) 取消保留底片
 * @method createByParams(array $params) 创建保留底片
 * @method delayByParams(array $params) 保留底片延期
 * @method usedCountByParams(array $params) 门店使用数量
 * @method expireByParams(array $params) 每天0点10分执行-过期保留数据
 */
class RetainPhotoOrder {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "NAS\\RetainPhotoOrder";

    /**
     * 获取门店保留底片操作记录
     * @return  array
    */
    public static function list (\Mainto\Bridge\Structs\FamilyPaperless\NAS\Cmd\RetainPhotoListCmd $retainPhotoListCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($retainPhotoListCmd);
    }

    /**
     * 取消保留底片
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cancel (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["orderId" => $orderId]);
    }

    /**
     * 创建保留底片
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\FamilyPaperless\NAS\Cmd\RetainPhotoCreateCmd $retainPhotoCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($retainPhotoCreateCmd);
    }

    /**
     * 保留底片延期
     * @return  bool
    */
    public static function delay (\Mainto\Bridge\Structs\FamilyPaperless\NAS\Cmd\RetainPhotoCreateCmd $retainPhotoCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delay($retainPhotoCreateCmd);
    }

    /**
     * 门店使用数量
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function usedCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->usedCount();
    }

    /**
     * 每天0点10分执行-过期保留数据
     * @return  bool
    */
    public static function expire () {
        return RpcClass::getClass(self::$serviceName, self::$className)->expire();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}