<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-03 18:23:07
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ReserveLookPhoto
 * @method lookListByParams(array $params) 看片排单表可约时间
 * @method addReservationByParams(array $params) 添加看片排单表预约
 * @method changeLookPhotoReserveTimeByParams(array $params) 修改看片预约时间
 * @method cancelLookPhotoReserveTimeByParams(array $params) 取消看片预约
 * @method allOrderListByParams(array $params) 预约看片全局订单查询
 * @method bigOrderListByParams(array $params) 大订单列表
 * @method lookingReservationByParams(array $params) 看片排单表
 * @method lookReservationDetailByParams(array $params) 看片预约排单表详情
 * @method bigOrderByParams(array $params) 是否是大订单
 * @method getSameStoreByParams(array $params) 获取同品牌、同价格区 已上线门店
 * @method setReservationByParams(array $params) 看片预约
 * @method updateReservationByParams(array $params) 修改看片预约时间
 * @method transferReservationByParams(array $params) 看片转门店
 * @method appointmentStateByParams(array $params) 看片排单表可约状态
 */
class ReserveLookPhoto {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\ReserveLookPhoto";

    /**
     * 看片排单表可约时间
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function lookList (string $dateStart, string $dateEnd, int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->lookList(array_merge($_params, ["dateStart" => $dateStart, "dateEnd" => $dateEnd, "orderId" => $orderId]));
    }

    /**
     * 添加看片排单表预约
     * @return  bool
    */
    public static function addReservation (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ReserveLookPhoto\ReserveLookPhotoReserveCmd $reserveLookPhotoReserveCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addReservation($reserveLookPhotoReserveCmd);
    }

    /**
     * 修改看片预约时间
     * @return  bool
    */
    public static function changeLookPhotoReserveTime (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ReserveLookPhoto\ChangeReserveLookPhotoReserveCmd $changeReserveLookPhotoReserveCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeLookPhotoReserveTime($changeReserveLookPhotoReserveCmd);
    }

    /**
     * 取消看片预约
     * @return  bool
    */
    public static function cancelLookPhotoReserveTime (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ReserveLookPhoto\CancelReserveLookPhotoReserveCmd $cancelReserveLookPhotoReserveCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelLookPhotoReserveTime($cancelReserveLookPhotoReserveCmd);
    }

    /**
     * 预约看片全局订单查询
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function allOrderList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allOrderList(array_merge($_params, []));
    }

    /**
     * 大订单列表
     * @return  array
    */
    public static function bigOrderList (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ReserveLookPhoto\BigOrderListCmd $bigOrderListCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bigOrderList($bigOrderListCmd);
    }

    /**
     * 看片排单表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function lookingReservation (string $dateStart, string $dateEnd, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->lookingReservation(array_merge($_params, ["dateStart" => $dateStart, "dateEnd" => $dateEnd]));
    }

    /**
     * 看片预约排单表详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function lookReservationDetail (string $selectDate, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->lookReservationDetail(array_merge($_params, ["selectDate" => $selectDate]));
    }

    /**
     * 是否是大订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function bigOrder (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bigOrder(["orderId" => $orderId]);
    }

    /**
     * 获取同品牌、同价格区 已上线门店
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getSameStore (array $productIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSameStore(array_merge($_params, ["productIds" => $productIds]));
    }

    /**
     * 看片预约
     * @return  bool
    */
    public static function setReservation (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ReserveLookPhoto\SetReservationCmd $setReservationCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setReservation($setReservationCmd);
    }

    /**
     * 修改看片预约时间
     * @return  bool
    */
    public static function updateReservation (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ReserveLookPhoto\UpdateReservationCmd $updateReservationCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateReservation($updateReservationCmd);
    }

    /**
     * 看片转门店
     * @return  bool
    */
    public static function transferReservation (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ReserveLookPhoto\TransferReservationCmd $transferReservationCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->transferReservation($transferReservationCmd);
    }

    /**
     * 看片排单表可约状态
     * @return  array
    */
    public static function appointmentState (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\ReserveLookPhoto\AppointmentStateCmd $appointmentStateCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->appointmentState($appointmentStateCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\ReserveLookPhoto\AppointmentStateDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}