<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-03 18:14:18
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Cron
 * @method queueToWaitingByParams(array $params) 每天9-23点每分钟执行-签到排队状态自动进入等待队列
 * @method dailyCleanByParams(array $params) 每天4点执行-清空前一日流程记录
 * @method removeStaffHangByParams(array $params) 每天9-23点每分钟执行-对超过1小时挂起的伙伴解除挂起
 * @method refreshProductIdsByParams(array $params) 每小时执行-重刷产品
 * @method dingUsersWhenOrderHangingTimeOutByParams(array $params) dingUsersWhenOrderHangingTimeOut
 * @method cronClearOrderUploadChangeSalesByParams(array $params) 定时清理订单上传更新标记
 * @method cronTakePhotoTipsByParams(array $params) 在线看片订单 每天10点和16点发送邮寄照片提醒
 * @method cronAutoReviewByParams(array $params) 待审核列表 流水云端审核完成 48h后自动审核完成
 * @method cronLookPhotoAutoCompleteByParams(array $params) 待看片单 自动看片完成（服务完成）
 * @method cronLookPhotoAutoCompleteV2ByParams(array $params) 待看片单 自动看片完成（服务完成）V2
 * @method cronLookPhotoNearAutoCompleteNoticeByParams(array $params) 在线看片订单 临近24小时通知即将自动看片完成 暂时不做
 * @method cronBusinessOutsideOrderByParams(array $params) 外拍订单7天内无流水上传 服务自动完成
 * @method cronCleanStudioAppIPByParams(array $params) 每分钟执行-将一小时外不上报IP的影棚IP清理掉
 * @method cronSyncCloudStreamRepairPhotoTimeByParams(array $params) 同步大数据云端修图预测时间
 * @method syncCloudStreamRepairPhotoTimeToRedisByParams(array $params) 同步数据库数据到redis
 * @method cronUpdateCloudStreamRepairPhotoCostTimeByParams(array $params) 同步大数据更新云端修图预测时间，每23分钟执行一次
 * @method cronSendLookPhotoNotifyByParams(array $params) 每天10-22点每7分钟执行-立等可取发送看片通知
 * @method cronSendProcessUploadPhotoNotifyByParams(array $params) 每天9-23点每分钟执行-立等可取订单process上传照片提醒
 * @method cronExpireRetainPhotoByParams(array $params) 00:10过期保留底片
 * @method cronSingleMakeUpAutoUploadPhotoByParams(array $params) 单化妆产品订单 自动上传图片
 * @method cronSingleMakeUpAutoLookCompleteByParams(array $params) 单化妆产品订单 自动看片完成
 */
class Cron {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\Cron";

    /**
     * 每天9-23点每分钟执行-签到排队状态自动进入等待队列
     * @return  bool
    */
    public static function queueToWaiting () {
        return RpcClass::getClass(self::$serviceName, self::$className)->queueToWaiting();
    }

    /**
     * 每天4点执行-清空前一日流程记录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function dailyClean (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dailyClean(array_merge($_params, []));
    }

    /**
     * 每天9-23点每分钟执行-对超过1小时挂起的伙伴解除挂起
     * @return  bool
    */
    public static function removeStaffHang () {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeStaffHang();
    }

    /**
     * 每小时执行-重刷产品
     * @return  bool
    */
    public static function refreshProductIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->refreshProductIds();
    }

    /**
     * dingUsersWhenOrderHangingTimeOut
     * @return  bool
    */
    public static function dingUsersWhenOrderHangingTimeOut () {
        return RpcClass::getClass(self::$serviceName, self::$className)->dingUsersWhenOrderHangingTimeOut();
    }

    /**
     * 定时清理订单上传更新标记
     * @return  bool
    */
    public static function cronClearOrderUploadChangeSales () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronClearOrderUploadChangeSales();
    }

    /**
     * 在线看片订单 每天10点和16点发送邮寄照片提醒
     * @return  bool
    */
    public static function cronTakePhotoTips () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronTakePhotoTips();
    }

    /**
     * 待审核列表 流水云端审核完成 48h后自动审核完成
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function cronAutoReview (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronAutoReview(array_merge($_params, []));
    }

    /**
     * 待看片单 自动看片完成（服务完成）
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function cronLookPhotoAutoComplete (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronLookPhotoAutoComplete(array_merge($_params, []));
    }

    /**
     * 待看片单 自动看片完成（服务完成）V2
     * @return  mixed
    */
    public static function cronLookPhotoAutoCompleteV2 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronLookPhotoAutoCompleteV2();
    }

    /**
     * 在线看片订单 临近24小时通知即将自动看片完成 暂时不做
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function cronLookPhotoNearAutoCompleteNotice (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronLookPhotoNearAutoCompleteNotice(array_merge($_params, []));
    }

    /**
     * 外拍订单7天内无流水上传 服务自动完成
     * @return  mixed
    */
    public static function cronBusinessOutsideOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronBusinessOutsideOrder();
    }

    /**
     * 每分钟执行-将一小时外不上报IP的影棚IP清理掉
     * @return  mixed
    */
    public static function cronCleanStudioAppIP () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronCleanStudioAppIP();
    }

    /**
     * 同步大数据云端修图预测时间
     * @return  mixed
    */
    public static function cronSyncCloudStreamRepairPhotoTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronSyncCloudStreamRepairPhotoTime();
    }

    /**
     * 同步数据库数据到redis
     * @return  mixed
    */
    public static function syncCloudStreamRepairPhotoTimeToRedis () {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncCloudStreamRepairPhotoTimeToRedis();
    }

    /**
     * 同步大数据更新云端修图预测时间，每23分钟执行一次
     * @return  mixed
    */
    public static function cronUpdateCloudStreamRepairPhotoCostTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronUpdateCloudStreamRepairPhotoCostTime();
    }

    /**
     * 每天10-22点每7分钟执行-立等可取发送看片通知
     * @return  bool
    */
    public static function cronSendLookPhotoNotify () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronSendLookPhotoNotify();
    }

    /**
     * 每天9-23点每分钟执行-立等可取订单process上传照片提醒
     * @return  bool
    */
    public static function cronSendProcessUploadPhotoNotify () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronSendProcessUploadPhotoNotify();
    }

    /**
     * 00:10过期保留底片
     * @return  bool
    */
    public static function cronExpireRetainPhoto () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronExpireRetainPhoto();
    }

    /**
     * 单化妆产品订单 自动上传图片
     * @return  bool
    */
    public static function cronSingleMakeUpAutoUploadPhoto () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronSingleMakeUpAutoUploadPhoto();
    }

    /**
     * 单化妆产品订单 自动看片完成
     * @return  bool
    */
    public static function cronSingleMakeUpAutoLookComplete () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronSingleMakeUpAutoLookComplete();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}