<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-03 18:14:18
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Cameraman
 * @method bindOrderUploadByParams(array $params) 订单添加至摄影师
 * @method revokeCloudStreamByParams(array $params) 撤回照片(流水维度)
 * @method revokeOrderByParams(array $params) 撤回订单照片
 * @method getCloudStreamInfoByParams(array $params) 云端流水详情
 * @method getHistoryInfoByParams(array $params) 获取订单历史上传记录详情
 * @method getHistoryListByParams(array $params) 获取摄影师历史上传记录列表
 * @method batchGetStreamInfoByIdsByParams(array $params) 批量获取流水详情
 * @method excellencePhotoUploadSettingByParams(array $params) 当前门店是否需要上传优秀底片
 * @method getOverUploadReasonsByParams(array $params) 获取超传原因列表
 */
class Cameraman {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\Cameraman";

    /**
     * 订单添加至摄影师
     * @return  bool
    */
    public static function bindOrderUpload (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\BindOrderCmd $bindOrderCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindOrderUpload($bindOrderCmd);
    }

    /**
     * 撤回照片(流水维度)
     * @return  bool
    */
    public static function revokeCloudStream (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeStreamCmd $revokeStreamCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokeCloudStream($revokeStreamCmd);
    }

    /**
     * 撤回订单照片
     * @return  bool
    */
    public static function revokeOrder (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Cameraman\RevokeOrderCmd $revokeOrderCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokeOrder($revokeOrderCmd);
    }

    /**
     * 云端流水详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCloudStreamInfo (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudStreamInfo(array_merge($_params, []));
    }

    /**
     * 获取订单历史上传记录详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getHistoryInfo (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryInfo(array_merge($_params, []));
    }

    /**
     * 获取摄影师历史上传记录列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getHistoryList (int $page = 1, int $pageSize = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 批量获取流水详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function batchGetStreamInfoByIds (string $brand = 'himo', array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetStreamInfoByIds(array_merge($_params, ["brand" => $brand]));
    }

    /**
     * 当前门店是否需要上传优秀底片
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\ExcellencePhotoUploadSettingDTO
    */
    public static function excellencePhotoUploadSetting () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->excellencePhotoUploadSetting(),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\ExcellencePhotoUploadSettingDTO"
        );
    }

    /**
     * 获取超传原因列表
     * @return  array
    */
    public static function getOverUploadReasons () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOverUploadReasons(),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\OverUploadReason\OverUploadReasonDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}