<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-02 16:57:12
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage\Paperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method saveNoteByParams(array $params) 更新订单备注信息
 * @method getOrderStageNumsByParams(array $params) 门店流程数量统计
 * @method assignStageStaffByParams(array $params) 指定订单接单伙伴
 * @method makeUpChangeStaffByParams(array $params) 化妆阶段更换伙伴 - 多人协作
 * @method cancelAssignStageStaffByParams(array $params) 清除订单接单伙伴
 * @method hangByParams(array $params) 挂起订单
 * @method cancelHangByParams(array $params) 取消挂起订单
 * @method changeStaffByParams(array $params) 更换伙伴
 * @method updateSortByParams(array $params) 更新接单顺序
 * @method getOrderAvailableStaffsByParams(array $params) 获取订单可选的伙伴列表
 * @method getOrderPreAssignStaffsByParams(array $params) 获取订单预指派的伙伴信息
 * @method getOrderCurrentAssignStaffsByParams(array $params) 获取订单当前指派的伙伴信息
 * @method getOrderCurrentAssignStaffs2ByParams(array $params) 获取订单当前指派的伙伴信息（蓝标）
 * @method getCanTakeOrderStaffIdsByParams(array $params) 获取订单可接单伙伴列表
 * @method backWaitPhotographyByParams(array $params) 退回至等待摄影
 * @method backWaitMakeUpByParams(array $params) 退回至等待化妆
 * @method hasOffProductsByParams(array $params) 订单中是否存在已下架产品
 * @method getStageStaffsByParams(array $params) 获取订单的伙伴列表
 * @method recoverByParams(array $params) 恢复到等待拍摄状态
 * @method checkNeedPaperlessByParams(array $params) 检查是否需要走钉钉无纸化（兼容family合并后部分老kids门店不走钉钉无纸化）
 * @method updateTechnicalPointsByParams(array $params) 更新订单下产品的技术要点
 * @method technicalPointsByParams(array $params) 获取订单下产品的技术要点
 * @method technicalPointsHistoryByParams(array $params) 获取订单下产品的技术要点（包含删除的数据）
 * @method cloudListByParams(array $params) 获取云端订单下所有正常流水
 * @method getMakeUpAssignStaffsByParams(array $params) 获取订单的协作分配信息
 * @method cancelAssistByParams(array $params) 取消协作
 * @method getAssignWorkloadsByParams(array $params) 获取订单的协作工作量信息
 * @method updatePhotoSizeAreasByParams(array $params) 更新订单下产品的登记地
 * @method getNeedPhotoSizeAreasByParams(array $params) 获取可录入登记地的产品ids
 * @method getPhotoSizeDetailByOrderIdByParams(array $params) 通过订单id获取登记地尺寸信息
 * @method needAssistantByParams(array $params) 订单是否需要协作化妆师
 * @method orderRetakeVoucherByParams(array $params) 获取订单重拍凭证
 * @method uploadRetakeVoucherByParams(array $params) 上传订单重拍凭证
 * @method autoAssignSecondRetoucherIdByParams(array $params) 获取云端自动指派信息
 */
class Order {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\Paperless\\Order";

    /**
     * 更新订单备注信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function saveNote (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveNote(array_merge($_params, []));
    }

    /**
     * 门店流程数量统计
     * @return  array
    */
    public static function getOrderStageNums (?\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\GetOrderStageNumsCmd $getOrderStageNumsCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderStageNums($getOrderStageNumsCmd);
    }

    /**
     * 指定订单接单伙伴
     * @return  bool
    */
    public static function assignStageStaff (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\AssignStageStaffCmd $assignStageStaffCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->assignStageStaff($assignStageStaffCmd);
    }

    /**
     * 化妆阶段更换伙伴 - 多人协作
     * @return  bool
    */
    public static function makeUpChangeStaff (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\MakeUp\MakeUpChangeStaffCmd $makeUpChangeStaffCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->makeUpChangeStaff($makeUpChangeStaffCmd);
    }

    /**
     * 清除订单接单伙伴
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function cancelAssignStageStaff (int $orderId, string $stage, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelAssignStageStaff(array_merge($_params, ["orderId" => $orderId, "stage" => $stage]));
    }

    /**
     * 挂起订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function hang (int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hang(array_merge($_params, ["orderId" => $orderId]));
    }

    /**
     * 取消挂起订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function cancelHang (int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelHang(array_merge($_params, ["orderId" => $orderId]));
    }

    /**
     * 更换伙伴
     * @return  bool
    */
    public static function changeStaff (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\ChangeStaffCmd $changeStaffCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeStaff($changeStaffCmd);
    }

    /**
     * 更新接单顺序
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function updateSort (int $orderId, int $sort, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSort(array_merge($_params, ["orderId" => $orderId, "sort" => $sort]));
    }

    /**
     * 获取订单可选的伙伴列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getOrderAvailableStaffs (int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderAvailableStaffs(array_merge($_params, ["orderId" => $orderId]));
    }

    /**
     * 获取订单预指派的伙伴信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getOrderPreAssignStaffs (int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderPreAssignStaffs(array_merge($_params, ["orderId" => $orderId]));
    }

    /**
     * 获取订单当前指派的伙伴信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderCurrentAssignStaffs (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderCurrentAssignStaffs(["orderId" => $orderId]);
    }

    /**
     * 获取订单当前指派的伙伴信息（蓝标）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\OrderPreAssignStaffsDTO
    */
    public static function getOrderCurrentAssignStaffs2 (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderCurrentAssignStaffs2(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\OrderPreAssignStaffsDTO"
        );
    }

    /**
     * 获取订单可接单伙伴列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\CanTakeOrderStaffDTO
    */
    public static function getCanTakeOrderStaffIds (int $orderId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCanTakeOrderStaffIds(array_merge($_params, ["orderId" => $orderId])),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\CanTakeOrderStaffDTO"
        );
    }

    /**
     * 退回至等待摄影
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function backWaitPhotography (int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->backWaitPhotography(array_merge($_params, ["orderId" => $orderId]));
    }

    /**
     * 退回至等待化妆
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function backWaitMakeUp (int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->backWaitMakeUp(array_merge($_params, ["orderId" => $orderId]));
    }

    /**
     * 订单中是否存在已下架产品
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function hasOffProducts (int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasOffProducts(array_merge($_params, ["orderId" => $orderId]));
    }

    /**
     * 获取订单的伙伴列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStageStaffs (int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStageStaffs(array_merge($_params, ["orderId" => $orderId]));
    }

    /**
     * 恢复到等待拍摄状态
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function recover (int $orderId, string $token, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recover(array_merge($_params, ["orderId" => $orderId, "token" => $token]));
    }

    /**
     * 检查是否需要走钉钉无纸化（兼容family合并后部分老kids门店不走钉钉无纸化）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function checkNeedPaperless (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkNeedPaperless(["storeId" => $storeId]);
    }

    /**
     * 更新订单下产品的技术要点
     * @return  bool
    */
    public static function updateTechnicalPoints (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\TechnicalPoint\UpdateOrderTechnicalPointCmd $updateOrderTechnicalPointCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTechnicalPoints($updateOrderTechnicalPointCmd);
    }

    /**
     * 获取订单下产品的技术要点
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function technicalPoints (int $orderId, bool $withDelete = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->technicalPoints(["orderId" => $orderId, "withDelete" => $withDelete]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\ProductTechnicalPointDTO[]"
        );
    }

    /**
     * 获取订单下产品的技术要点（包含删除的数据）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function technicalPointsHistory (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->technicalPointsHistory(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\ProductTechnicalPointDTO[]"
        );
    }

    /**
     * 获取云端订单下所有正常流水
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function cloudList (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->cloudList(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\CloudListDTO[]"
        );
    }

    /**
     * 获取订单的协作分配信息
     * @return  array
    */
    public static function getMakeUpAssignStaffs (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\OrderMakeUpAssistantCmd $orderMakeUpAssistantCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMakeUpAssignStaffs($orderMakeUpAssistantCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\ProcessAssistantPeopleDTO[]"
        );
    }

    /**
     * 取消协作
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cancelAssist (int $processId, int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelAssist(["processId" => $processId, "staffId" => $staffId]);
    }

    /**
     * 获取订单的协作工作量信息
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Workload\OrderAssistantWorkloadDTO
    */
    public static function getAssignWorkloads (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Workload\OrderAssignWorkloadCmd $orderAssignWorkloadCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAssignWorkloads($orderAssignWorkloadCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Workload\OrderAssistantWorkloadDTO"
        );
    }

    /**
     * 更新订单下产品的登记地
     * @return  bool
    */
    public static function updatePhotoSizeAreas (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\PhotoSizeArea\UpdatePhotoSizeAreaCmd $updatePhotoSizeAreaCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePhotoSizeAreas($updatePhotoSizeAreaCmd);
    }

    /**
     * 获取可录入登记地的产品ids
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getNeedPhotoSizeAreas (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNeedPhotoSizeAreas(["orderId" => $orderId]);
    }

    /**
     * 通过订单id获取登记地尺寸信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPhotoSizeDetailByOrderId (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPhotoSizeDetailByOrderId(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Paperless\ProcessPhotoSizeDTO[]"
        );
    }

    /**
     * 订单是否需要协作化妆师
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function needAssistant (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->needAssistant(["orderId" => $orderId]);
    }

    /**
     * 获取订单重拍凭证
     * @return  array
    */
    public static function orderRetakeVoucher (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\RetakeOrder\OrderRetakeVoucherCmd $orderRetakeVoucherCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderRetakeVoucher($orderRetakeVoucherCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Order\OrderRetakeVoucherDTO[]"
        );
    }

    /**
     * 上传订单重拍凭证
     * @return  bool
    */
    public static function uploadRetakeVoucher (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\RetakeOrder\OrderUploadRetakeVoucherCmd $orderUploadRetakeVoucherCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadRetakeVoucher($orderUploadRetakeVoucherCmd);
    }

    /**
     * 获取云端自动指派信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function autoAssignSecondRetoucherId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoAssignSecondRetoucherId(["orderId" => $orderId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}