<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-02 16:57:12
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class CloudStreamQueue
 * @method getSelfStoreStreamQueueByParams(array $params) 获取本门店云端队列信息
 * @method getAllStoreStreamQueueByParams(array $params) 获取全国门店云端队列信息
 * @method queueCountByParams(array $params) 获取本门店云端队列信息数量
 * @method getTodaySupervisorsByParams(array $params) 获取修图主管
 */
class CloudStreamQueue {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\CloudStreamQueue";

    /**
     * 获取本门店云端队列信息
     * @return  array
    */
    public static function getSelfStoreStreamQueue (?\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\StreamQueue\QueueListCmd $queueListCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSelfStoreStreamQueue($queueListCmd);
    }

    /**
     * 获取全国门店云端队列信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getAllStoreStreamQueue (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStoreStreamQueue(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取本门店云端队列信息数量
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\StreamQueue\CloudQueueCountDTO
    */
    public static function queueCount () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queueCount(),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\StreamQueue\CloudQueueCountDTO"
        );
    }

    /**
     * 获取修图主管
     * @return  mixed
    */
    public static function getTodaySupervisors () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTodaySupervisors();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}