<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-02 16:57:12
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PaperlessOrder
 * @method paperlessOrderListByParams(array $params) 无纸化订单列表
 * @method getFirstFinishLookPhotoStaffIdByParams(array $params) 获取第一次看片完成的看片师id
 * @method orderPhotographyInfoByParams(array $params) 获取订单摄影信息
 * @method cancelTeaseByParams(array $params) 取消引逗
 * @method stageListByParams(array $params) 根据无纸化状态获取门店订单列表
 * @method processDetailByParams(array $params) 获取process详情
 * @method processStreamByParams(array $params) 获取process下流水的详情
 * @method batchOrderServiceStaffInfoByParams(array $params) batchOrderServiceStaffInfo
 * @method getStaffServiceOrderListByParams(array $params) getStaffServiceOrderList
 * @method getOrderPhotosByParams(array $params) 获取订单照片
 * @method clearCollectStoresCacheByParams(array $params) 清除中台协作产品缓存
 * @method ordersProductSortByParams(array $params) 获取无纸化订单产品排序信息
 */
class PaperlessOrder {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Api\\PaperlessOrder";

    /**
     * 无纸化订单列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function paperlessOrderList (int $page = 1, int $pageSize = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paperlessOrderList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取第一次看片完成的看片师id
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function getFirstFinishLookPhotoStaffId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFirstFinishLookPhotoStaffId(["orderId" => $orderId]);
    }

    /**
     * 获取订单摄影信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\SalaryProduct\SalaryOrderDTO
    */
    public static function orderPhotographyInfo (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderPhotographyInfo(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\SalaryProduct\SalaryOrderDTO"
        );
    }

    /**
     * 取消引逗
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function cancelTease (array $processIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelTease(array_merge($_params, ["processIds" => $processIds]));
    }

    /**
     * 根据无纸化状态获取门店订单列表
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\PaperlessOrderStagePageDTO
    */
    public static function stageList (\Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\PaperlessOrderStageListCmd $paperlessOrderStageListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->stageList($paperlessOrderStageListCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\PaperlessOrderStagePageDTO"
        );
    }

    /**
     * 获取process详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\ProcessDTO
    */
    public static function processDetail (int $processId, bool $withTrashed = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->processDetail(["processId" => $processId, "withTrashed" => $withTrashed]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\ProcessDTO"
        );
    }

    /**
     * 获取process下流水的详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function processStream (int $processId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->processStream(["processId" => $processId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\StreamDTO[]"
        );
    }

    /**
     * batchOrderServiceStaffInfo
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchOrderServiceStaffInfo (array $orderIds, array $stages) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchOrderServiceStaffInfo(["orderIds" => $orderIds, "stages" => $stages]);
    }

    /**
     * getStaffServiceOrderList
     * @return  array
    */
    public static function getStaffServiceOrderList (\Mainto\Bridge\Structs\FamilyPaperless\Api\Cmd\StaffServiceOrderCmd $staffServiceOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStaffServiceOrderList($staffServiceOrderCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\StaffServiceDTO[]"
        );
    }

    /**
     * 获取订单照片
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderPhotos (string $orderNo, int $saleId = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderPhotos(["orderNo" => $orderNo, "saleId" => $saleId]);
    }

    /**
     * 清除中台协作产品缓存
     * @return  bool
    */
    public static function clearCollectStoresCache () {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearCollectStoresCache();
    }

    /**
     * 获取无纸化订单产品排序信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function ordersProductSort (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->ordersProductSort(["orderIds" => $orderIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}