<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-02 14:27:44
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Product
 * @method productRetouchStyleByParams(array $params) 获取云端产品的修图风格
 * @method productRetouchStyleV2ByParams(array $params) 获取云端产品的修图风格V2
 * @method cloudProductInfoByParams(array $params) 获取云端产品信息
 * @method cloudTechnologyDetailByParams(array $params) 获取产品的技术要点
 */
class Product {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Manage\\Product";

    /**
     * 获取云端产品的修图风格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productRetouchStyle (int $productId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productRetouchStyle(["productId" => $productId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\RetouchStyleResDTO[]"
        );
    }

    /**
     * 获取云端产品的修图风格V2
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\RetouchStyleV2\ProductRetouchStyleV2DTO
    */
    public static function productRetouchStyleV2 (int $processId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productRetouchStyleV2(["processId" => $processId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\RetouchStyleV2\ProductRetouchStyleV2DTO"
        );
    }

    /**
     * 获取云端产品信息
     * @return  \Mainto\RpcServer\Util\Types\Map
    */
    public static function cloudProductInfo (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Product\CloudProductListCmd $cloudProductListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->cloudProductInfo($cloudProductListCmd),
            "\Mainto\RpcServer\Util\Types\Map<int, \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\CloudProductDTO>"
        );
    }

    /**
     * 获取产品的技术要点
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function cloudTechnologyDetail (int $productId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->cloudTechnologyDetail(array_merge($_params, ["productId" => $productId])),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\Product\ProductTechnicalPointDetailDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}