<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-02 14:27:44
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Ding;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OrderDing
 * @method detailByParams(array $params) 订单详情
 * @method saveNoteByParams(array $params) 更新订单备注信息
 * @method getWaitingCountByParams(array $params) 获取等待数量
 * @method duringWorkByParams(array $params) 获取用时明细
 * @method getOrderProductsByParams(array $params) 获取订单购买的产品
 * @method getPhotographicPoseByParams(array $params) 获取订单摄影动作
 */
class OrderDing {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Ding\\OrderDing";

    /**
     * 订单详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function detail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(array_merge($_params, []));
    }

    /**
     * 更新订单备注信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function saveNote (bool $append = false, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveNote(array_merge($_params, ["append" => $append]));
    }

    /**
     * 获取等待数量
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetWaitingCountDTO
    */
    public static function getWaitingCount () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getWaitingCount(),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetWaitingCountDTO"
        );
    }

    /**
     * 获取用时明细
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function duringWork (int $orderId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->duringWork(array_merge($_params, ["orderId" => $orderId])),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\DuringWorkDTO[]"
        );
    }

    /**
     * 获取订单购买的产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetOrderProductsDTO
    */
    public static function getOrderProducts (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderProducts(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetOrderProductsDTO"
        );
    }

    /**
     * 获取订单摄影动作
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\RpcServer\Util\Types\Map
    */
    public static function getPhotographicPose (array $orderIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotographicPose(array_merge($_params, ["orderIds" => $orderIds]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}