<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-19 14:29:12
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\OnlineShooting;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ShootingStudio
 */
class ShootingStudio {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "OnlineShooting\\ShootingStudio";

    /**
     * 获取可选的门店列表
     * @return  array
    */
    public static function stores () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->stores(),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StoreDTO[]"
        );
    }
    /**
     * 获取门店影棚列表
     * @return  array
    */
    public static function studioBindList (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->studioBindList(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioBindListDTO[]"
        );
    }
    /**
     * 绑定门店影棚和设备
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioBindDTO
    */
    public static function studioBind (\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\Cmd\StudioBindCmd $studioBindCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->studioBind($studioBindCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioBindDTO"
        );
    }
    /**
     * 验证联机拍摄应用登录
     * @return  int
    */
    public static function login (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->login($_params);
    }
    /**
     * 上报当前应用IP
     * @return  bool
    */
    public static function updateAppIP (\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\Cmd\UpdateIPCmd $updateIPCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateAppIP($updateIPCmd);
    }
    /**
     * 获取当前影棚未初始化的流程
     * @return  array
    */
    public static function getNotReadyProcess () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getNotReadyProcess(),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\ProcessShootingAppNotReadyDTO[]"
        );
    }
    /**
     * 设置影棚订单初始化成功
     * @return  bool
    */
    public static function setProcessReady (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProcessReady($_params);
    }
    /**
     * 获取当前门店摄影机ip列表
     * @return  array
    */
    public static function shootingAppIPs (array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->shootingAppIPs($_params),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioDetailDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}