<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-17 11:40:12
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class StaffState
 * @method staffStateByParams(array $params) 获取伙伴工作状态
 * @method staffsWorkStateByParams(array $params) 批量获取伙伴工作状态
 * @method switchStateByParams(array $params) 服务管家|店长切换状态
 * @method eatenStaffsByParams(array $params) 已经吃过饭的伙伴id数组
 */
class StaffState {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "Api\\StaffState";

    /**
     * 获取伙伴工作状态
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\StaffState\StaffStateDTO
    */
    public static function staffState (int $storeId, int $staffId, string $staffType) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->staffState(["storeId" => $storeId, "staffId" => $staffId, "staffType" => $staffType]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\StaffState\StaffStateDTO"
        );
    }
    /**
     * 批量获取伙伴工作状态
     * @return  array
    */
    public static function staffsWorkState (array $staffs) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->staffsWorkState(["staffs" => $staffs]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Api\DTO\StaffState\StaffWorkStateDTO[]"
        );
    }
    /**
     * 服务管家|店长切换状态
     * @return  bool
    */
    public static function switchState (int $storeId, int $staffId, string $staffType, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->switchState(["storeId" => $storeId, "staffId" => $staffId, "staffType" => $staffType, "status" => $status]);
    }
    /**
     * 已经吃过饭的伙伴id数组
     * @return  array
    */
    public static function eatenStaffs (array $staffs) {
        return RpcClass::getClass(self::$serviceName, self::$className)->eatenStaffs(["staffs" => $staffs]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}