<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-16 17:25:23
 */
namespace Mainto\Bridge\Invokes\FamilyPaperless\OnlineShooting;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ShootingStudio
 * @method storesByParams(array $params) 获取可选的门店列表
 * @method studioBindListByParams(array $params) 获取门店影棚列表
 * @method studioBindByParams(array $params) 绑定门店影棚和设备
 * @method loginByParams(array $params) 验证联机拍摄应用登录
 * @method updateAppIPByParams(array $params) 上报当前应用IP
 * @method getNotReadyProcessByParams(array $params) 获取当前影棚未初始化的流程
 * @method setProcessReadyByParams(array $params) 设置影棚订单初始化成功
 * @method shootingAppIPsByParams(array $params) 获取当前门店摄影机ip列表
 */
class ShootingStudio {
    private static string $serviceName = "FamilyPaperless";

    private static string $className = "OnlineShooting\\ShootingStudio";

    /**
     * 获取可选的门店列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function stores () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->stores(),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StoreDTO[]"
        );
    }
    /**
     * 获取门店影棚列表
     * @return  array
    */
    public static function studioBindList (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->studioBindList(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioBindListDTO[]"
        );
    }
    /**
     * 绑定门店影棚和设备
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioBindDTO
    */
    public static function studioBind (\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\Cmd\StudioBindCmd $studioBindCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->studioBind($studioBindCmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioBindDTO"
        );
    }
    /**
     * 验证联机拍摄应用登录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  int
    */
    public static function login (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->login($_params);
    }
    /**
     * 上报当前应用IP
     * @return  bool
    */
    public static function updateAppIP (\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\Cmd\UpdateIPCmd $updateIPCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateAppIP($updateIPCmd);
    }
    /**
     * 获取当前影棚未初始化的流程
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getNotReadyProcess () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getNotReadyProcess(),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\ProcessShootingAppNotReadyDTO[]"
        );
    }
    /**
     * 设置影棚订单初始化成功
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function setProcessReady (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProcessReady($_params);
    }
    /**
     * 获取当前门店摄影机ip列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function shootingAppIPs (array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->shootingAppIPs($_params),
            "\Mainto\Bridge\Structs\FamilyPaperless\OnlineShooting\DTO\StudioDetailDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}